/*
 * Decompiled with CFR 0.152.
 */
package org.zoodb.index.critbit;

public class BitTools {
    public static long toSortableLong(double value) {
        long r = Double.doubleToRawLongBits(value);
        return r >= 0L ? r : r ^ Long.MAX_VALUE;
    }

    public static long toSortableLong(float value) {
        int r = Float.floatToRawIntBits(value);
        return r >= 0 ? (long)r : (long)(r ^ Integer.MAX_VALUE);
    }

    public static double toDouble(long value) {
        return Double.longBitsToDouble((double)value >= 0.0 ? value : value ^ Long.MAX_VALUE);
    }

    public static float toFloat(long value) {
        int iVal = (int)value;
        return Float.intBitsToFloat((double)iVal >= 0.0 ? iVal : iVal ^ Integer.MAX_VALUE);
    }

    public static long[] toSortableLong(double[] value, long[] ret) {
        for (int i = 0; i < value.length; ++i) {
            long r = Double.doubleToRawLongBits(value[i]);
            ret[i] = r >= 0L ? r : r ^ Long.MAX_VALUE;
        }
        return ret;
    }

    public static long[] toSortableLong(float[] value, long[] ret) {
        for (int i = 0; i < value.length; ++i) {
            int r = Float.floatToRawIntBits(value[i]);
            ret[i] = r >= 0 ? (long)r : (long)(r ^ Integer.MAX_VALUE);
        }
        return ret;
    }

    public static double[] toDouble(long[] value, double[] ret) {
        for (int i = 0; i < value.length; ++i) {
            ret[i] = Double.longBitsToDouble((double)value[i] >= 0.0 ? value[i] : value[i] ^ Long.MAX_VALUE);
        }
        return ret;
    }

    public static float[] toFloat(long[] value, float[] ret) {
        for (int i = 0; i < value.length; ++i) {
            int iVal = (int)value[i];
            ret[i] = Float.intBitsToFloat((double)iVal >= 0.0 ? iVal : iVal ^ Integer.MAX_VALUE);
        }
        return ret;
    }

    public static long toSortableLong(String s2) {
        int i;
        long n = 0L;
        for (i = 0; i < 6 && i < s2.length(); ++i) {
            n |= (long)((byte)s2.charAt(i));
            n <<= 8;
        }
        while (i < 6) {
            n <<= 8;
            ++i;
        }
        n <<= 8;
        return n |= (long)(0xFFFF & s2.hashCode());
    }

    public static long reverse(long l, int usedBits) {
        long r = Long.reverse(l);
        return r >>>= 64 - usedBits;
    }

    public static void split(long toSplit, long[] trgV, int trg1, int trg2, int nBits) {
        long maskSrc = 1L << nBits - 1;
        long t1 = 0L;
        long t2 = 0L;
        for (int i = 0; i < nBits; ++i) {
            if ((i & 1) == 0) {
                t1 <<= 1;
                if ((toSplit & maskSrc) != 0L) {
                    t1 |= 1L;
                }
            } else {
                t2 <<= 1;
                if ((toSplit & maskSrc) != 0L) {
                    t2 |= 1L;
                }
            }
            maskSrc >>>= 1;
        }
        trgV[trg1] = t1;
        trgV[trg2] = t2;
    }

    public static long merge(long[] srcV, int src1, int src2, int nBits) {
        long maskTrg = 1L;
        long v = 0L;
        long s1 = srcV[src1];
        long s2 = srcV[src2];
        for (int i = nBits - 1; i >= 0; --i) {
            if ((i & 1) == 0) {
                if ((s1 & 1L) == 1L) {
                    v |= maskTrg;
                }
                s1 >>>= 1;
            } else {
                if ((s2 & 1L) == 1L) {
                    v |= maskTrg;
                }
                s2 >>>= 1;
            }
            maskTrg <<= 1;
        }
        return v;
    }

    public static long[] mergeLong(int nBitsPerValue, long[] src) {
        int DIM = src.length;
        int intArrayLen = src.length * nBitsPerValue + 63 >>> 6;
        long[] trg = new long[intArrayLen];
        long maskSrc = 1L << nBitsPerValue - 1;
        long maskTrg = Long.MIN_VALUE;
        int srcPos = 0;
        int trgPos = 0;
        for (int j = 0; j < nBitsPerValue * DIM; ++j) {
            if ((src[srcPos] & maskSrc) != 0L) {
                int n = trgPos;
                trg[n] = trg[n] | maskTrg;
            } else {
                int n = trgPos;
                trg[n] = trg[n] & (maskTrg ^ 0xFFFFFFFFFFFFFFFFL);
            }
            if ((maskTrg >>>= 1) == 0L) {
                maskTrg = Long.MIN_VALUE;
                ++trgPos;
            }
            if (++srcPos != DIM) continue;
            srcPos = 0;
            maskSrc >>>= 1;
        }
        return trg;
    }

    public static long[] splitLong(int dims, int nBitsPerValue, long[] toSplit) {
        long[] trg = new long[dims];
        long maskTrg = 1L << nBitsPerValue - 1;
        for (int k = 0; k < nBitsPerValue; ++k) {
            for (int j = 0; j < trg.length; ++j) {
                int posBit = k * trg.length + j;
                boolean bit = BitTools.getBit(toSplit, posBit);
                if (!bit) continue;
                int n = j;
                trg[n] = trg[n] | maskTrg;
            }
            maskTrg >>>= 1;
        }
        return trg;
    }

    public static boolean getBit(long[] ba, int posBit) {
        int pA = posBit >>> 6;
        return (ba[pA] & Long.MIN_VALUE >>> (posBit &= 0x3F)) != 0L;
    }

    public static boolean getBit(long l, int posBit) {
        return (l & Long.MIN_VALUE >>> posBit) != 0L;
    }

    public static boolean getAndCopyBit(long[] src, int posBit, long[] dst) {
        int pA = posBit >>> 6;
        long mask = Long.MIN_VALUE >>> (posBit &= 0x3F);
        if ((src[pA] & mask) != 0L) {
            int n = pA;
            dst[n] = dst[n] | mask;
            return true;
        }
        int n = pA;
        dst[n] = dst[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        return false;
    }

    public static void setBit(long[] ba, int posBit, boolean b) {
        int pA = posBit >>> 6;
        posBit &= 0x3F;
        if (b) {
            int n = pA;
            ba[n] = ba[n] | Long.MIN_VALUE >>> posBit;
        } else {
            int n = pA;
            ba[n] = ba[n] & (Long.MIN_VALUE >>> posBit ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static long setBit(long ba, int posBit, boolean b) {
        if (b) {
            return ba | Long.MIN_VALUE >>> posBit;
        }
        return ba & (Long.MIN_VALUE >>> posBit ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long set1(long ba, int posBit) {
        return ba | Long.MIN_VALUE >>> posBit;
    }

    public static long set0(long ba, int posBit) {
        return ba & (Long.MIN_VALUE >>> posBit ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static String toBinary(long[] la, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        for (long l : la) {
            sb.append(BitTools.toBinary(l, DEPTH));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toBinary(long l, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < DEPTH; ++i) {
            long mask = 1L << (int)((long)(DEPTH - i - 1));
            if ((l & mask) != 0L) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            if ((i + 1) % 8 == 0 && i + 1 < DEPTH) {
                sb.append('.');
            }
            mask >>>= 1;
        }
        return sb.toString();
    }
}

