/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.geoparquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetFileFormatBase;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetReadSupport;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetUtils$;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.DataTypeUtils$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetFilters;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetOptions;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.PortableSQLConf;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.PortableSQLConf$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.RebaseSpec;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tmb\u0001\u0002\f\u0018\u0001\u0019B\u0001B\u0014\u0001\u0003\u0006\u0004%\ta\u0014\u0005\t/\u0002\u0011\t\u0011)A\u0005!\")\u0001\f\u0001C\u00013\")\u0001\f\u0001C\u00019\")Q\f\u0001C!=\")q\r\u0001C!Q\")A\u000e\u0001C![\")a\u000f\u0001C\u0001o\")\u0011\u0010\u0001C!u\"9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA-\u0001\u0011\u0005\u00131\f\u0005\b\u0003K\u0003A\u0011IAT\u0011\u001d\t\u0019\f\u0001C!\u0003k;q!!0\u0018\u0011\u0003\tyL\u0002\u0004\u0017/!\u0005\u0011\u0011\u0019\u0005\u00071>!\t!a6\t\u000f\u0005ew\u0002\"\u0001\u0002\\\"9\u0011Q]\b\u0005\n\u0005\u001d\bb\u0002B\u000b\u001f\u0011%!q\u0003\u0005\b\u0005CyA\u0011\u0002B\u0012\u0011%\u0011YcDA\u0001\n\u0013\u0011iC\u0001\u000bHK>\u0004\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u00031e\t!bZ3pa\u0006\u0014\u0018/^3u\u0015\tQ2$A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\u000f\u001e\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001f?\u0005\u00191/\u001d7\u000b\u0005\u0001\n\u0013!B:qCJ\\'B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c\u0001aE\u0004\u0001O5\nTg\u000f!\u0011\u0005!ZS\"A\u0015\u000b\u0005):\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u00051J#!\u0005)beF,X\r\u001e$jY\u00164uN]7biB\u0011afL\u0007\u0002/%\u0011\u0001g\u0006\u0002\u0019\u000f\u0016|\u0007+\u0019:rk\u0016$h)\u001b7f\r>\u0014X.\u0019;CCN,\u0007C\u0001\u001a4\u001b\u0005I\u0012B\u0001\u001b\u001a\u0005)1\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003mej\u0011a\u000e\u0006\u0003qu\tqa]8ve\u000e,7/\u0003\u0002;o\t\u0011B)\u0019;b'>,(oY3SK\u001eL7\u000f^3s!\tad(D\u0001>\u0015\tQs$\u0003\u0002@{\t9Aj\\4hS:<\u0007CA!L\u001d\t\u0011\u0005J\u0004\u0002D\r6\tAI\u0003\u0002FK\u00051AH]8pizJ\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013*\u000bq\u0001]1dW\u0006<WMC\u0001H\u0013\taUJ\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002J\u0015\u0006i1\u000f]1uS\u0006dg)\u001b7uKJ,\u0012\u0001\u0015\t\u0004#J#V\"\u0001&\n\u0005MS%AB(qi&|g\u000e\u0005\u0002/+&\u0011ak\u0006\u0002\u0018\u000f\u0016|\u0007+\u0019:rk\u0016$8\u000b]1uS\u0006dg)\u001b7uKJ\fab\u001d9bi&\fGNR5mi\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u00035n\u0003\"A\f\u0001\t\u000b9\u001b\u0001\u0019\u0001)\u0015\u0003i\u000ba!Z9vC2\u001cHCA0c!\t\t\u0006-\u0003\u0002b\u0015\n9!i\\8mK\u0006t\u0007\"B2\u0006\u0001\u0004!\u0017!B8uQ\u0016\u0014\bCA)f\u0013\t1'JA\u0002B]f\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002SB\u0011\u0011K[\u0005\u0003W*\u00131!\u00138u\u0003!!xn\u0015;sS:<G#\u00018\u0011\u0005=\u001chB\u00019r!\t\u0019%*\u0003\u0002s\u0015\u00061\u0001K]3eK\u001aL!\u0001^;\u0003\rM#(/\u001b8h\u0015\t\u0011(*A\u000bxSRD7\u000b]1uS\u0006d\u0007K]3eS\u000e\fG/Z:\u0015\u0005iC\b\"\u0002(\t\u0001\u0004!\u0016aC5oM\u0016\u00148k\u00195f[\u0006$ra_A\u0003\u0003#\tY\u0002E\u0002R%r\u00042!`A\u0001\u001b\u0005q(BA@\u001e\u0003\u0015!\u0018\u0010]3t\u0013\r\t\u0019A \u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA\u0004\u0013\u0001\u0007\u0011\u0011B\u0001\rgB\f'o[*fgNLwN\u001c\t\u0005\u0003\u0017\ti!D\u0001\u001e\u0013\r\ty!\b\u0002\r'B\f'o[*fgNLwN\u001c\u0005\b\u0003'I\u0001\u0019AA\u000b\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0006_\u0006]aN\\\u0005\u0004\u00033)(aA'ba\"9\u0011QD\u0005A\u0002\u0005}\u0011!\u00024jY\u0016\u001c\b#B!\u0002\"\u0005\u0015\u0012bAA\u0012\u001b\n\u00191+Z9\u0011\t\u0005\u001d\u0012\u0011G\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005\u0011am\u001d\u0006\u0004\u0003_\t\u0013A\u00025bI>|\u0007/\u0003\u0003\u00024\u0005%\"A\u0003$jY\u0016\u001cF/\u0019;vg\u0006a\u0001O]3qCJ,wK]5uKRQ\u0011\u0011HA \u0003\u0003\n\t&!\u0016\u0011\u0007I\nY$C\u0002\u0002>e\u00111cT;uaV$xK]5uKJ4\u0015m\u0019;pefDq!a\u0002\u000b\u0001\u0004\tI\u0001C\u0004\u0002D)\u0001\r!!\u0012\u0002\u0007)|'\r\u0005\u0003\u0002H\u00055SBAA%\u0015\u0011\tY%!\f\u0002\u00135\f\u0007O]3ek\u000e,\u0017\u0002BA(\u0003\u0013\u00121AS8c\u0011\u001d\t\u0019F\u0003a\u0001\u0003+\tqa\u001c9uS>t7\u000f\u0003\u0004\u0002X)\u0001\r\u0001`\u0001\u000bI\u0006$\u0018mU2iK6\f\u0017A\b2vS2$'+Z1eKJ<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]Z\u000bG.^3t)A\ti&a\u001f\u0002~\u0005}\u00141QAD\u0003'\u000b)\nE\u0004R\u0003?\n\u0019'!\u001b\n\u0007\u0005\u0005$JA\u0005Gk:\u001cG/[8ocA\u0019!'!\u001a\n\u0007\u0005\u001d\u0014DA\bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f!\u0015\t\u00151NA8\u0013\r\ti'\u0014\u0002\t\u0013R,'/\u0019;peB!\u0011\u0011OA<\u001b\t\t\u0019HC\u0002\u0002vu\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003s\n\u0019HA\u0006J]R,'O\\1m%><\bbBA\u0004\u0017\u0001\u0007\u0011\u0011\u0002\u0005\u0007\u0003/Z\u0001\u0019\u0001?\t\r\u0005\u00055\u00021\u0001}\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007BBAC\u0017\u0001\u0007A0\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\t\u000f\u0005%5\u00021\u0001\u0002\f\u00069a-\u001b7uKJ\u001c\b#B!\u0002\"\u00055\u0005c\u0001\u001c\u0002\u0010&\u0019\u0011\u0011S\u001c\u0003\r\u0019KG\u000e^3s\u0011\u001d\t\u0019f\u0003a\u0001\u0003+Aq!a&\f\u0001\u0004\tI*\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!a'\u0002\"6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000bi#\u0001\u0003d_:4\u0017\u0002BAR\u0003;\u0013QbQ8oM&<WO]1uS>t\u0017aD:vaB|'\u000f\u001e#bi\u0006$\u0016\u0010]3\u0015\u0007}\u000bI\u000bC\u0004\u0002,2\u0001\r!!,\u0002\u0011\u0011\fG/\u0019+za\u0016\u00042!`AX\u0013\r\t\tL \u0002\t\t\u0006$\u0018\rV=qK\u0006a1/\u001e9q_J$()\u0019;dQR)q,a.\u0002:\"9\u0011qA\u0007A\u0002\u0005%\u0001BBA^\u001b\u0001\u0007A0\u0001\u0004tG\",W.Y\u0001\u0015\u000f\u0016|\u0007+\u0019:rk\u0016$h)\u001b7f\r>\u0014X.\u0019;\u0011\u00059z1CB\b\u0002Dn\nI\rE\u0002R\u0003\u000bL1!a2K\u0005\u0019\te.\u001f*fMB!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017AA5p\u0015\t\t\u0019.\u0001\u0003kCZ\f\u0017b\u0001'\u0002NR\u0011\u0011qX\u0001\u0017[\u0016\u0014x-Z*dQ\u0016l\u0017m]%o!\u0006\u0014\u0018\r\u001c7fYR910!8\u0002`\u0006\r\bbBA\n#\u0001\u0007\u0011Q\u0003\u0005\b\u0003C\f\u0002\u0019AA\u0010\u000311\u0017\u000e\\3t)>$v.^2i\u0011\u001d\t9!\u0005a\u0001\u0003\u0013\tAC]3bIN\u001b\u0007.Z7b\rJ|WNR8pi\u0016\u0014H#\u0003?\u0002j\u0006m(\u0011\u0002B\n\u0011\u001d\tYO\u0005a\u0001\u0003[\faAZ8pi\u0016\u0014\b\u0003BAx\u0003ol!!!=\u000b\t\u0005=\u00121\u001f\u0006\u0004\u0003k\f\u0013a\u00029beF,X\r^\u0005\u0005\u0003s\f\tP\u0001\u0004G_>$XM\u001d\u0005\b\u0003{\u0014\u0002\u0019AA\u0000\u0003AYW-\u001f,bYV,W*\u001a;b\t\u0006$\u0018\r\u0005\u0004\u0003\u0002\t\u001daN\\\u0007\u0003\u0005\u0007QAA!\u0002\u0002R\u0006!Q\u000f^5m\u0013\u0011\tIBa\u0001\t\u000f\t-!\u00031\u0001\u0003\u000e\u0005I1m\u001c8wKJ$XM\u001d\t\u0004]\t=\u0011b\u0001B\t/\t\u0001s)Z8QCJ\fX/\u001a;U_N\u0003\u0018M]6TG\",W.Y\"p]Z,'\u000f^3s\u0011\u001d\t\u0019B\u0005a\u0001\u0003+\tq\u0003Z3tKJL\u0017\r\\5{KN\u001b\u0007.Z7b'R\u0014\u0018N\\4\u0015\u000fm\u0014IB!\b\u0003 !1!1D\nA\u00029\fAb]2iK6\f7\u000b\u001e:j]\u001eDq!!@\u0014\u0001\u0004\ty\u0010C\u0004\u0002\u0014M\u0001\r!!\u0006\u0002II,\u0007\u000f\\1dK\u001e+w.\\3uef\u001cu\u000e\\;n]^KG\u000f[$f_6,GO]=V\tR#r\u0001 B\u0013\u0005O\u0011I\u0003\u0003\u0004\u0002<R\u0001\r\u0001 \u0005\b\u0003{$\u0002\u0019AA\u0000\u0011\u001d\t\u0019\u0002\u0006a\u0001\u0003+\tAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\f\u0011\t\tE\"qG\u0007\u0003\u0005gQAA!\u000e\u0002R\u0006!A.\u00198h\u0013\u0011\u0011IDa\r\u0003\r=\u0013'.Z2u\u0001")
public class GeoParquetFileFormat
extends ParquetFileFormat
implements GeoParquetFileFormatBase {
    private final Option<GeoParquetSpatialFilter> spatialFilter;

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        return GeoParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, filesToTouch, sparkSession);
    }

    @Override
    public String shortName() {
        return GeoParquetFileFormatBase.shortName$(this);
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GeoParquetFileFormat)) return false;
        Option<GeoParquetSpatialFilter> option = ((GeoParquetFileFormat)other).spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = this.spatialFilter();
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public String toString() {
        return new StringBuilder(10).append("GeoParquet").append(this.spatialFilter().map((Function1 & Serializable)filter -> new StringBuilder(23).append(" with spatial filter [").append(filter.simpleString()).append("]").toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
    }

    @Override
    public GeoParquetFileFormat withSpatialPredicates(GeoParquetSpatialFilter spatialFilter) {
        return new GeoParquetFileFormat((Option<GeoParquetSpatialFilter>)new Some((Object)spatialFilter));
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return GeoParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        PortableSQLConf sqlConf = new PortableSQLConf(sparkSession.sessionState().conf());
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(PortableSQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(PortableSQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(PortableSQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(PortableSQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), Boolean.toString(sqlConf.writeLegacyParquetFormat()));
        conf.set(PortableSQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sqlConf.parquetOutputTimestampType().toString());
        conf.set(PortableSQLConf$.MODULE$.PARQUET_FIELD_ID_WRITE_ENABLED().key(), Boolean.toString(sqlConf.parquetFieldIdWriteEnabled()));
        conf.set(PortableSQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), Boolean.toString(sqlConf.legacyParquetNanosAsLong()));
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(134).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append("Set Parquet option parquet.summary.metadata.level to NONE.").toString());
        }
        conf.set("parquet.write.support.class", GeoParquetWriteSupport.class.getName());
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        PortableSQLConf conf = new PortableSQLConf(sparkSession.sessionState().conf());
        hadoopConf.set(PortableSQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), conf.sessionLocalTimeZone());
        hadoopConf.setBoolean(PortableSQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), conf.nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(PortableSQLConf$.MODULE$.CASE_SENSITIVE().key(), conf.caseSensitiveAnalysis());
        hadoopConf.setBoolean(PortableSQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), conf.isParquetBinaryAsString());
        hadoopConf.setBoolean(PortableSQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), conf.isParquetINT96AsTimestamp());
        hadoopConf.setBoolean(PortableSQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), conf.parquetInferTimestampNTZEnabled());
        hadoopConf.setBoolean(PortableSQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), conf.legacyParquetNanosAsLong());
        hadoopConf.setBoolean("spark.databricks.scan.modTimeCheck.enabled", false);
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Object)requiredSchema.fields(), ClassTag$.MODULE$.apply(StructField.class)));
        PortableSQLConf sqlConf = new PortableSQLConf(sparkSession.sessionState().conf());
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$1)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean parquetFilterPushDownStringPredicate = sqlConf.parquetFilterPushDownStringPredicate();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        ParquetOptions parquetOptions = new ParquetOptions(options, new PortableSQLConf(sparkSession.sessionState().conf()));
        String datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
        String int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
        return (Function1 & Serializable)file -> {
            Iterator iterator;
            ParquetRecordReader parquetRecordReader;
            None$ none$;
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = file.toPath();
            FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            FileMetaData footerFileMetaData = ParquetFooterReader.readFooter(sharedConf, file, true).getFileMetaData();
            Map map = footerFileMetaData.getKeyValueMetaData();
            RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
            Map map2 = footerFileMetaData.getKeyValueMetaData();
            RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = footerFileMetaData.getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, parquetFilterPushDownStringPredicate, pushDownInFilterThreshold, isCaseSensitive, datetimeRebaseSpec);
                none$ = ((IterableOnceOps)filters.flatMap((Function1 & Serializable)x$2 -> parquetFilters.createFilter((Filter)x$2))).reduceOption((Function2 & Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            boolean shouldScanFile = GeoParquetMetaData$.MODULE$.parseKeyValueMetaData(footerFileMetaData.getKeyValueMetaData()).forall((Function1 & Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$7(this, metadata)));
            if (!shouldScanFile) {
                return package$.MODULE$.Seq().empty().iterator();
            }
            None$ convertTz = timestampConversion && !GeoParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(PortableSQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            if (enableVectorizedReader) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "GeoParquet currently does not support vectorized reader. Falling back to parquet-mr");
            }
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Falling back to parquet-mr");
            GeoParquetReadSupport readSupport = new GeoParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseSpec, int96RebaseSpec, options);
            if (pushed.isDefined() && enableRecordFilter) {
                FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
            } else {
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
            }
            ParquetRecordReader reader = parquetRecordReader;
            RecordReader<Void, InternalRow> readerWithRowIndexes = ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded((ParquetRecordReader<InternalRow>)reader, requiredSchema);
            RecordReaderIterator iter = new RecordReaderIterator(readerWithRowIndexes);
            try {
                readerWithRowIndexes.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus(DataTypeUtils$.MODULE$.toAttributes(partitionSchema));
                UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                if (partitionSchema.length() == 0) {
                    iterator = iter.map((Function1)unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    iterator = iter.map((Function1 & Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            catch (Throwable e) {
                iter.close();
                throw e;
            }
            return iterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        return super.supportDataType(dataType);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$7(GeoParquetFileFormat $this, GeoParquetMetaData metadata) {
        return $this.spatialFilter().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.evaluate(metadata.columns())));
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public GeoParquetFileFormat(Option<GeoParquetSpatialFilter> spatialFilter) {
        this.spatialFilter = spatialFilter;
        GeoParquetFileFormatBase.$init$(this);
    }

    public GeoParquetFileFormat() {
        this((Option<GeoParquetSpatialFilter>)None$.MODULE$);
    }
}

