/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.UnsafeInput;
import com.esotericsoftware.kryo.io.UnsafeOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.sedona.common.S2Geography.EncodeOptions;
import org.apache.sedona.common.S2Geography.EncodeTag;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.shaded.s2.S2Region;
import org.apache.sedona.shaded.s2.S2Shape;
import org.apache.sedona.shaded.s2.S2ShapeIndex;
import org.apache.sedona.shaded.s2.S2ShapeIndexCoder;
import org.apache.sedona.shaded.s2.S2ShapeIndexRegion;
import org.apache.sedona.shaded.s2.VectorCoder;

public class ShapeIndexGeography
extends Geography {
    public S2ShapeIndex shapeIndex;

    public ShapeIndexGeography() {
        super(Geography.GeographyKind.SHAPE_INDEX);
        this.shapeIndex = new S2ShapeIndex();
    }

    public ShapeIndexGeography(Geography geog) {
        super(Geography.GeographyKind.SHAPE_INDEX);
        this.shapeIndex = new S2ShapeIndex();
        this.addIndex(geog);
    }

    public ShapeIndexGeography(int maxEdgesPerCell) {
        super(Geography.GeographyKind.SHAPE_INDEX);
        S2ShapeIndex.Options options = new S2ShapeIndex.Options();
        options.setMaxEdgesPerCell(maxEdgesPerCell);
        this.shapeIndex = new S2ShapeIndex(options);
    }

    @Override
    public int dimension() {
        return -1;
    }

    @Override
    public int numShapes() {
        return this.shapeIndex.getShapes().size();
    }

    @Override
    public S2Shape shape(int id) {
        S2Shape raw = this.shapeIndex.getShapes().get(id);
        return raw;
    }

    @Override
    public S2Region region() {
        return new S2ShapeIndexRegion(this.shapeIndex);
    }

    public void addIndex(Geography geog) {
        int n = geog.numShapes();
        for (int i = 0; i < n; ++i) {
            this.shapeIndex.add(geog.shape(i));
        }
    }

    @Override
    public void encode(UnsafeOutput out, EncodeOptions opts) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output tmpOut = new Output((OutputStream)baos);
        switch (opts.getCodingHint()) {
            case FAST: {
                VectorCoder.FAST_SHAPE.encode(this.shapeIndex.getShapes(), (OutputStream)tmpOut);
                break;
            }
            case COMPACT: {
                VectorCoder.COMPACT_SHAPE.encode(this.shapeIndex.getShapes(), (OutputStream)tmpOut);
            }
        }
        tmpOut.flush();
        byte[] payload = baos.toByteArray();
        out.writeInt(payload.length, false);
        out.writeBytes(payload);
        S2ShapeIndexCoder.INSTANCE.encode(this.shapeIndex, (OutputStream)out);
        out.flush();
    }

    public static ShapeIndexGeography decode(UnsafeInput in, EncodeTag tag) throws IOException {
        throw new IOException("Decode() not implemented for ShapeIndexGeography()");
    }
}

