/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.ProvisioningState;
import com.microsoft.azure.management.containerregistry.Registry;
import com.microsoft.azure.management.containerregistry.Webhook;
import com.microsoft.azure.management.containerregistry.WebhookAction;
import com.microsoft.azure.management.containerregistry.WebhookCreateParameters;
import com.microsoft.azure.management.containerregistry.WebhookEventInfo;
import com.microsoft.azure.management.containerregistry.WebhookStatus;
import com.microsoft.azure.management.containerregistry.WebhookUpdateParameters;
import com.microsoft.azure.management.containerregistry.implementation.CallbackConfigInner;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerregistry.implementation.EventInfoInner;
import com.microsoft.azure.management.containerregistry.implementation.EventInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryImpl;
import com.microsoft.azure.management.containerregistry.implementation.WebhookEventInfoImpl;
import com.microsoft.azure.management.containerregistry.implementation.WebhookInner;
import com.microsoft.azure.management.containerregistry.implementation.WebhooksInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class WebhookImpl
extends ExternalChildResourceImpl<Webhook, WebhookInner, RegistryImpl, Registry>
implements Webhook,
Webhook.WebhookDefinition<Registry.DefinitionStages.WithCreate>,
Webhook.UpdateDefinition<Registry.Update>,
Webhook.UpdateResource<Registry.Update>,
Webhook.Update {
    private WebhookCreateParameters webhookCreateParametersInner;
    private WebhookUpdateParameters webhookUpdateParametersInner;
    private Map<String, String> tags;
    private Map<String, String> customHeaders;
    private String serviceUri;
    private boolean isInCreateMode;
    private ContainerRegistryManager containerRegistryManager;
    private String resourceGroupName;
    private String registryName;

    WebhookImpl(String name, RegistryImpl parent, WebhookInner innerObject, ContainerRegistryManager containerRegistryManager) {
        super(name, (Object)parent, (Object)innerObject);
        this.containerRegistryManager = containerRegistryManager;
        if (parent != null) {
            this.resourceGroupName = parent.resourceGroupName();
            this.registryName = parent.name();
        }
        this.initCreateUpdateParams();
    }

    WebhookImpl(String resourceGroupName, String registryName, String name, WebhookInner innerObject, ContainerRegistryManager containerRegistryManager) {
        super(name, null, (Object)innerObject);
        this.containerRegistryManager = containerRegistryManager;
        this.resourceGroupName = resourceGroupName;
        this.registryName = registryName;
        this.initCreateUpdateParams();
    }

    private void initCreateUpdateParams() {
        this.webhookCreateParametersInner = null;
        this.webhookUpdateParametersInner = null;
        this.isInCreateMode = false;
    }

    public String id() {
        return ((WebhookInner)((Object)this.inner())).id();
    }

    public String type() {
        return ((WebhookInner)((Object)this.inner())).type();
    }

    public String regionName() {
        return ((WebhookInner)((Object)this.inner())).location();
    }

    public Region region() {
        return Region.findByLabelOrName((String)this.regionName());
    }

    public Map<String, String> tags() {
        TreeMap tags = ((WebhookInner)((Object)this.inner())).getTags();
        if (tags == null) {
            tags = new TreeMap();
        }
        return Collections.unmodifiableMap(tags);
    }

    @Override
    public boolean isEnabled() {
        return ((WebhookInner)((Object)this.inner())).status().equals((Object)WebhookStatus.ENABLED);
    }

    @Override
    public String scope() {
        return ((WebhookInner)((Object)this.inner())).scope();
    }

    @Override
    public String serviceUri() {
        return this.serviceUri;
    }

    @Override
    public Map<String, String> customHeaders() {
        return Collections.unmodifiableMap(this.customHeaders);
    }

    @Override
    public Collection<WebhookAction> triggers() {
        return Collections.unmodifiableCollection(((WebhookInner)((Object)this.inner())).actions());
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((WebhookInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)this.id());
    }

    @Override
    public void enable() {
        this.update().enabled(true).apply();
    }

    @Override
    public Completable enableAsync() {
        return this.update().enabled(true).applyAsync().toCompletable();
    }

    @Override
    public void disable() {
        this.update().enabled(false).apply();
    }

    @Override
    public Completable disableAsync() {
        return this.update().enabled(false).applyAsync().toCompletable();
    }

    @Override
    public String ping() {
        return ((ContainerRegistryManagementClientImpl)((Object)this.containerRegistryManager.inner())).webhooks().ping(this.resourceGroupName, this.registryName, this.name()).id();
    }

    @Override
    public Observable<String> pingAsync() {
        return ((ContainerRegistryManagementClientImpl)((Object)this.containerRegistryManager.inner())).webhooks().pingAsync(this.resourceGroupName, this.registryName, this.name()).map((Func1)new Func1<EventInfoInner, String>(){

            public String call(EventInfoInner eventInfoInner) {
                return eventInfoInner.id();
            }
        });
    }

    @Override
    public PagedList<WebhookEventInfo> listEvents() {
        WebhookImpl self = this;
        PagedListConverter<EventInner, WebhookEventInfo> converter = new PagedListConverter<EventInner, WebhookEventInfo>(){

            public Observable<WebhookEventInfo> typeConvertAsync(EventInner inner) {
                return Observable.just((Object)new WebhookEventInfoImpl(inner));
            }
        };
        return converter.convert(((ContainerRegistryManagementClientImpl)((Object)this.containerRegistryManager.inner())).webhooks().listEvents(self.resourceGroupName, self.registryName, self.name()));
    }

    @Override
    public Observable<WebhookEventInfo> listEventsAsync() {
        WebhookImpl self = this;
        return ((ContainerRegistryManagementClientImpl)((Object)this.containerRegistryManager.inner())).webhooks().listEventsAsync(self.resourceGroupName, self.registryName, self.name()).flatMap((Func1)new Func1<Page<EventInner>, Observable<EventInner>>(){

            public Observable<EventInner> call(Page<EventInner> eventInnerPage) {
                return Observable.from((Iterable)eventInnerPage.items());
            }
        }).map((Func1)new Func1<EventInner, WebhookEventInfo>(){

            public WebhookEventInfo call(EventInner inner) {
                return new WebhookEventInfoImpl(inner);
            }
        });
    }

    public Observable<Webhook> createResourceAsync() {
        final WebhookImpl self = this;
        if (this.webhookCreateParametersInner != null) {
            return ((ContainerRegistryManagementClientImpl)((Object)this.containerRegistryManager.inner())).webhooks().createAsync(self.resourceGroupName, this.registryName, this.name(), this.webhookCreateParametersInner).map((Func1)new Func1<WebhookInner, WebhookImpl>(){

                public WebhookImpl call(WebhookInner inner) {
                    self.webhookCreateParametersInner = null;
                    self.setInner((Object)inner);
                    return self;
                }
            }).flatMap((Func1)new Func1<WebhookImpl, Observable<Webhook>>(){

                public Observable<Webhook> call(WebhookImpl webhook) {
                    return self.setCallbackConfigAsync();
                }
            });
        }
        return Observable.just((Object)this).map((Func1)new Func1<WebhookImpl, Webhook>(){

            public Webhook call(WebhookImpl webhook) {
                return webhook;
            }
        });
    }

    WebhookImpl setCallbackConfig(CallbackConfigInner callbackConfigInner) {
        this.serviceUri = callbackConfigInner.serviceUri();
        this.customHeaders = callbackConfigInner.customHeaders() != null ? callbackConfigInner.customHeaders() : new HashMap<String, String>();
        return this;
    }

    Observable<Webhook> setCallbackConfigAsync() {
        final WebhookImpl self = this;
        return ((ContainerRegistryManagementClientImpl)((Object)this.containerRegistryManager.inner())).webhooks().getCallbackConfigAsync(self.resourceGroupName, self.registryName, self.name()).map((Func1)new Func1<CallbackConfigInner, Webhook>(){

            public Webhook call(CallbackConfigInner callbackConfigInner) {
                WebhookImpl.this.setCallbackConfig(callbackConfigInner);
                return self;
            }
        });
    }

    public Observable<Webhook> updateResourceAsync() {
        final WebhookImpl self = this;
        if (this.webhookUpdateParametersInner != null) {
            return ((ContainerRegistryManagementClientImpl)((Object)this.containerRegistryManager.inner())).webhooks().updateAsync(self.resourceGroupName, self.registryName, self.name(), self.webhookUpdateParametersInner).map((Func1)new Func1<WebhookInner, WebhookImpl>(){

                public WebhookImpl call(WebhookInner inner) {
                    self.setInner((Object)inner);
                    self.webhookUpdateParametersInner = null;
                    return self;
                }
            }).flatMap((Func1)new Func1<WebhookImpl, Observable<Webhook>>(){

                public Observable<Webhook> call(WebhookImpl webhook) {
                    return self.setCallbackConfigAsync();
                }
            });
        }
        return Observable.just((Object)this).map((Func1)new Func1<WebhookImpl, Webhook>(){

            public Webhook call(WebhookImpl webhook) {
                return webhook;
            }
        });
    }

    public Observable<Void> deleteResourceAsync() {
        return ((ContainerRegistryManagementClientImpl)((Object)this.containerRegistryManager.inner())).webhooks().deleteAsync(this.resourceGroupName, this.registryName, this.name());
    }

    protected Observable<WebhookInner> getInnerAsync() {
        final WebhookImpl self = this;
        final WebhooksInner webhooksInner = ((ContainerRegistryManagementClientImpl)((Object)this.containerRegistryManager.inner())).webhooks();
        return webhooksInner.getAsync(this.resourceGroupName, this.registryName, this.name()).flatMap((Func1)new Func1<WebhookInner, Observable<CallbackConfigInner>>(){

            public Observable<CallbackConfigInner> call(WebhookInner webhookInner) {
                self.setInner((Object)webhookInner);
                return webhooksInner.getCallbackConfigAsync(self.resourceGroupName, self.registryName, self.name());
            }
        }).map((Func1)new Func1<CallbackConfigInner, WebhookInner>(){

            public WebhookInner call(CallbackConfigInner callbackConfigInner) {
                return (WebhookInner)((Object)WebhookImpl.this.setCallbackConfig(callbackConfigInner).inner());
            }
        });
    }

    public Webhook apply() {
        return (Webhook)this.applyAsync().toBlocking().last();
    }

    public Observable<Webhook> applyAsync() {
        return this.updateResourceAsync();
    }

    public ServiceFuture<Webhook> applyAsync(ServiceCallback<Webhook> callback) {
        return ServiceFuture.fromBody(this.updateResourceAsync(), callback);
    }

    public WebhookImpl update() {
        this.setCreateMode(false);
        return this;
    }

    public RegistryImpl attach() {
        return (RegistryImpl)this.parent();
    }

    WebhookImpl setCreateMode(boolean isInCreateMode) {
        this.isInCreateMode = isInCreateMode;
        if (this.isInCreateMode && this.parent() != null) {
            this.webhookCreateParametersInner = new WebhookCreateParameters().withLocation(((RegistryImpl)this.parent()).regionName());
        } else {
            this.webhookUpdateParametersInner = new WebhookUpdateParameters();
        }
        return this;
    }

    public WebhookImpl withTags(Map<String, String> tags) {
        if (tags != null) {
            this.tags = null;
            this.ensureValidTags();
            for (Map.Entry entry : ((WebhookInner)((Object)this.inner())).getTags().entrySet()) {
                this.tags.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return this;
    }

    public WebhookImpl withTag(String key, String value) {
        if (key != null && value != null) {
            this.ensureValidTags().put(key, value);
        }
        return this;
    }

    public WebhookImpl withoutTag(String key) {
        if (key != null && this.tags != null) {
            this.tags.remove(key);
        }
        return this;
    }

    @Override
    public WebhookImpl withTriggerWhen(WebhookAction ... webhookActions) {
        if (webhookActions != null) {
            if (this.isInCreateMode) {
                this.ensureWebhookCreateParametersInner().withActions(Arrays.asList(webhookActions));
            } else {
                this.ensureWebhookUpdateParametersInner().withActions(Arrays.asList(webhookActions));
            }
        }
        return this;
    }

    @Override
    public WebhookImpl withServiceUri(String serviceUri) {
        if (serviceUri != null) {
            if (this.isInCreateMode) {
                this.ensureWebhookCreateParametersInner().withServiceUri(serviceUri);
            } else {
                this.ensureWebhookUpdateParametersInner().withServiceUri(serviceUri);
            }
        }
        return this;
    }

    @Override
    public WebhookImpl withCustomHeader(String name, String value) {
        if (name != null && value != null) {
            this.ensureValidCustomHeaders().put(name, value);
        }
        return this;
    }

    @Override
    public WebhookImpl withCustomHeaders(Map<String, String> customHeaders) {
        if (customHeaders != null) {
            this.customHeaders = null;
            this.ensureValidCustomHeaders();
            for (Map.Entry entry : ((WebhookInner)((Object)this.inner())).getTags().entrySet()) {
                this.customHeaders.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return this;
    }

    @Override
    public WebhookImpl withRepositoriesScope(String repositoriesScope) {
        if (repositoriesScope != null) {
            if (this.isInCreateMode) {
                this.ensureWebhookCreateParametersInner().withScope(repositoriesScope);
            } else {
                this.ensureWebhookUpdateParametersInner().withScope(repositoriesScope);
            }
        }
        return this;
    }

    @Override
    public WebhookImpl enabled(boolean defaultStatus) {
        WebhookStatus status;
        WebhookStatus webhookStatus = status = defaultStatus ? WebhookStatus.ENABLED : WebhookStatus.DISABLED;
        if (this.isInCreateMode) {
            this.ensureWebhookCreateParametersInner().withStatus(status);
        } else {
            this.ensureWebhookUpdateParametersInner().withStatus(status);
        }
        return this;
    }

    private WebhookCreateParameters ensureWebhookCreateParametersInner() {
        if (this.webhookCreateParametersInner == null && this.parent() != null) {
            this.webhookCreateParametersInner = new WebhookCreateParameters().withLocation(((RegistryImpl)this.parent()).regionName());
        }
        return this.webhookCreateParametersInner;
    }

    private WebhookUpdateParameters ensureWebhookUpdateParametersInner() {
        if (this.webhookUpdateParametersInner == null && this.parent() != null) {
            this.webhookUpdateParametersInner = new WebhookUpdateParameters();
        }
        return this.webhookUpdateParametersInner;
    }

    private Map<String, String> ensureValidTags() {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
            if (this.isInCreateMode) {
                this.ensureWebhookCreateParametersInner().withTags(this.tags);
            } else {
                this.ensureWebhookUpdateParametersInner().withTags(this.tags);
            }
        }
        return this.tags;
    }

    private Map<String, String> ensureValidCustomHeaders() {
        if (this.customHeaders == null) {
            this.customHeaders = new HashMap<String, String>();
            if (this.isInCreateMode) {
                this.ensureWebhookCreateParametersInner().withCustomHeaders(this.customHeaders);
            } else {
                this.ensureWebhookUpdateParametersInner().withCustomHeaders(this.customHeaders);
            }
        }
        return this.customHeaders;
    }
}

