/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.paimon.hive;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;

/** A {@link HiveMetaStoreClient} to test creating table failed in Hive metastore client. */
public class CreateFailHiveMetaStoreClient extends HiveMetaStoreClient implements IMetaStoreClient {

    public CreateFailHiveMetaStoreClient(Configuration conf) throws MetaException {
        super(conf);
    }

    public CreateFailHiveMetaStoreClient(Configuration conf, HiveMetaHookLoader hookLoader)
            throws MetaException {
        super(conf, hookLoader);
    }

    public CreateFailHiveMetaStoreClient(
            Configuration conf, HiveMetaHookLoader hookLoader, Boolean allowEmbedded)
            throws MetaException {
        super(conf, hookLoader, allowEmbedded);
    }

    @Override
    public void createTable(Table tbl)
            throws AlreadyExistsException, InvalidObjectException, MetaException,
                    NoSuchObjectException, TException {
        throw new TException();
    }

    @Override
    public void alter_table(String defaultDatabaseName, String tblName, Table table)
            throws InvalidOperationException, MetaException, TException {
        throw new TException();
    }
}
