/****************************************************************************
 * arch/risc-v/src/rp23xx-rv/hardware/rp23xx_dreq.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_RISC_V_SRC_RP23XX_HARDWARE_RP23XX_DREQ_H
#define __ARCH_RISC_V_SRC_RP23XX_HARDWARE_RP23XX_DREQ_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include "hardware/rp23xx_memorymap.h"

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

#define RP23XX_DMA_DREQ_PIO0_TX0 0
#define RP23XX_DMA_DREQ_PIO0_TX1 1
#define RP23XX_DMA_DREQ_PIO0_TX2 2
#define RP23XX_DMA_DREQ_PIO0_TX3 3
#define RP23XX_DMA_DREQ_PIO0_RX0 4
#define RP23XX_DMA_DREQ_PIO0_RX1 5
#define RP23XX_DMA_DREQ_PIO0_RX2 6
#define RP23XX_DMA_DREQ_PIO0_RX3 7
#define RP23XX_DMA_DREQ_PIO1_TX0 8
#define RP23XX_DMA_DREQ_PIO1_TX1 9
#define RP23XX_DMA_DREQ_PIO1_TX2 10
#define RP23XX_DMA_DREQ_PIO1_TX3 11
#define RP23XX_DMA_DREQ_PIO1_RX0 12
#define RP23XX_DMA_DREQ_PIO1_RX1 13
#define RP23XX_DMA_DREQ_PIO1_RX2 14
#define RP23XX_DMA_DREQ_PIO1_RX3 15
#define RP23XX_DMA_DREQ_PIO2_TX0 16
#define RP23XX_DMA_DREQ_PIO2_TX1 17
#define RP23XX_DMA_DREQ_PIO2_TX2 18
#define RP23XX_DMA_DREQ_PIO2_TX3 19
#define RP23XX_DMA_DREQ_PIO2_RX0 20
#define RP23XX_DMA_DREQ_PIO2_RX1 21
#define RP23XX_DMA_DREQ_PIO2_RX2 22
#define RP23XX_DMA_DREQ_PIO2_RX3 23
#define RP23XX_DMA_DREQ_SPI0_TX 24
#define RP23XX_DMA_DREQ_SPI0_RX 25
#define RP23XX_DMA_DREQ_SPI1_TX 26
#define RP23XX_DMA_DREQ_SPI1_RX 27
#define RP23XX_DMA_DREQ_UART0_TX 28
#define RP23XX_DMA_DREQ_UART0_RX 29
#define RP23XX_DMA_DREQ_UART1_TX 30
#define RP23XX_DMA_DREQ_UART1_RX 31
#define RP23XX_DMA_DREQ_PWM_WRAP0 32
#define RP23XX_DMA_DREQ_PWM_WRAP1 33
#define RP23XX_DMA_DREQ_PWM_WRAP2 34
#define RP23XX_DMA_DREQ_PWM_WRAP3 35
#define RP23XX_DMA_DREQ_PWM_WRAP4 36
#define RP23XX_DMA_DREQ_PWM_WRAP5 37
#define RP23XX_DMA_DREQ_PWM_WRAP6 38
#define RP23XX_DMA_DREQ_PWM_WRAP7 39
#define RP23XX_DMA_DREQ_PWM_WRAP8 40
#define RP23XX_DMA_DREQ_PWM_WRAP9 41
#define RP23XX_DMA_DREQ_PWM_WRAP10 42
#define RP23XX_DMA_DREQ_PWM_WRAP11 43
#define RP23XX_DMA_DREQ_I2C0_TX 44
#define RP23XX_DMA_DREQ_I2C0_RX 45
#define RP23XX_DMA_DREQ_I2C1_TX 46
#define RP23XX_DMA_DREQ_I2C1_RX 47
#define RP23XX_DMA_DREQ_ADC 48
#define RP23XX_DMA_DREQ_XIP_STREAM 49
#define RP23XX_DMA_DREQ_XIP_QMITX 50
#define RP23XX_DMA_DREQ_XIP_QMIRX 51
#define RP23XX_DMA_DREQ_HSTX 52
#define RP23XX_DMA_DREQ_CORESIGHT 53
#define RP23XX_DMA_DREQ_SHA256 54
#define RP23XX_DMA_DREQ_DMA_TIMER0 59
#define RP23XX_DMA_DREQ_DMA_TIMER1 60
#define RP23XX_DMA_DREQ_DMA_TIMER2 61
#define RP23XX_DMA_DREQ_DMA_TIMER3 62
#define RP23XX_DMA_DREQ_FORCE 63
#define RP23XX_DMA_DREQ_COUNT 64

#endif /* __ARCH_RISC_V_SRC_RP23XX_HARDWARE_RP23XX_DREQ_H */
