/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.nifi.bootstrap.configuration.BootstrapProperty;
import org.apache.nifi.bootstrap.configuration.ConfigurationProvider;
import org.apache.nifi.bootstrap.configuration.EnvironmentVariable;
import org.apache.nifi.bootstrap.configuration.SystemProperty;

public class StandardConfigurationProvider
implements ConfigurationProvider {
    private static final String CONFIGURATION_DIRECTORY = "conf";
    private static final String LIBRARY_DIRECTORY = "lib";
    private static final String LOG_DIRECTORY = "logs";
    private static final String APPLICATION_PROPERTIES = "nifi.properties";
    private static final String BOOTSTRAP_CONFIGURATION = "bootstrap.conf";
    private static final String CURRENT_DIRECTORY = "";
    private static final Duration GRACEFUL_SHUTDOWN_TIMEOUT = Duration.ofSeconds(20L);
    private final Map<String, String> environmentVariables;
    private final Properties systemProperties;
    private final Properties bootstrapProperties = new Properties();

    public StandardConfigurationProvider(Map<String, String> environmentVariables, Properties systemProperties) {
        this.environmentVariables = Objects.requireNonNull(environmentVariables);
        this.systemProperties = Objects.requireNonNull(systemProperties);
        this.setBootstrapProperties();
    }

    @Override
    public List<String> getAdditionalArguments() {
        return this.bootstrapProperties.stringPropertyNames().stream().filter(name -> name.startsWith(BootstrapProperty.JAVA_ARGUMENT.getProperty())).sorted().map(this.bootstrapProperties::getProperty).filter(Predicate.not(String::isBlank)).toList();
    }

    @Override
    public Path getApplicationProperties() {
        Path configurationDirectory = this.getConfigurationDirectory();
        Path applicationProperties = configurationDirectory.resolve(APPLICATION_PROPERTIES);
        if (Files.notExists(applicationProperties, new LinkOption[0])) {
            throw new IllegalStateException("Application Properties [%s] not found".formatted(applicationProperties));
        }
        return applicationProperties;
    }

    @Override
    public Path getBootstrapConfiguration() {
        Path bootstrapConfiguration;
        String bootstrapConfigurationProperty = System.getProperty(SystemProperty.BOOTSTRAP_CONFIGURATION.getProperty());
        if (this.isEmpty(bootstrapConfigurationProperty)) {
            Path configurationDirectory = this.getConfigurationDirectory();
            bootstrapConfiguration = configurationDirectory.resolve(BOOTSTRAP_CONFIGURATION);
        } else {
            bootstrapConfiguration = Paths.get(bootstrapConfigurationProperty, new String[0]).toAbsolutePath();
        }
        if (Files.notExists(bootstrapConfiguration, new LinkOption[0])) {
            throw new IllegalStateException("Bootstrap Configuration [%s] not found".formatted(bootstrapConfiguration));
        }
        return bootstrapConfiguration;
    }

    @Override
    public Path getLibraryDirectory() {
        Path libraryDirectory = this.getResolvedDirectory(BootstrapProperty.LIBRARY_DIRECTORY, LIBRARY_DIRECTORY);
        if (Files.notExists(libraryDirectory, new LinkOption[0])) {
            throw new IllegalStateException("Library Directory [%s] not found".formatted(libraryDirectory));
        }
        return libraryDirectory;
    }

    @Override
    public Path getLogDirectory() {
        Path logDirectory;
        String logDirectoryProperty = this.systemProperties.getProperty(SystemProperty.LOG_DIRECTORY.getProperty());
        if (this.isEmpty(logDirectoryProperty)) {
            Path applicationHome = this.getApplicationHome();
            logDirectory = applicationHome.resolve(LOG_DIRECTORY);
        } else {
            logDirectory = Paths.get(logDirectoryProperty, new String[0]);
        }
        return logDirectory;
    }

    @Override
    public Duration getGracefulShutdownTimeout() {
        Duration gracefulShutdownTimeout;
        String gracefulShutdownSecondsProperty = this.bootstrapProperties.getProperty(BootstrapProperty.GRACEFUL_SHUTDOWN_SECONDS.getProperty());
        if (gracefulShutdownSecondsProperty == null || gracefulShutdownSecondsProperty.isEmpty()) {
            gracefulShutdownTimeout = GRACEFUL_SHUTDOWN_TIMEOUT;
        } else {
            int gracefulShutdownSeconds = Integer.parseInt(gracefulShutdownSecondsProperty);
            gracefulShutdownTimeout = Duration.ofSeconds(gracefulShutdownSeconds);
        }
        return gracefulShutdownTimeout;
    }

    @Override
    public Optional<URI> getManagementServerAddress() {
        Optional<URI> managementServerAddress;
        String managementServerAddressProperty = this.bootstrapProperties.getProperty(BootstrapProperty.MANAGEMENT_SERVER_ADDRESS.getProperty());
        if (managementServerAddressProperty == null || managementServerAddressProperty.isEmpty()) {
            managementServerAddress = Optional.empty();
        } else {
            URI serverAddress = URI.create(managementServerAddressProperty);
            managementServerAddress = Optional.of(serverAddress);
        }
        return managementServerAddress;
    }

    @Override
    public Path getConfigurationDirectory() {
        Path configurationDirectory = this.getResolvedDirectory(BootstrapProperty.CONFIGURATION_DIRECTORY, CONFIGURATION_DIRECTORY);
        if (Files.notExists(configurationDirectory, new LinkOption[0])) {
            throw new IllegalStateException("Configuration Directory [%s] not found".formatted(configurationDirectory));
        }
        return configurationDirectory;
    }

    @Override
    public Path getWorkingDirectory() {
        String workingDirectoryProperty = this.bootstrapProperties.getProperty(BootstrapProperty.WORKING_DIRECTORY.getProperty());
        Path workingDirectory = this.isEmpty(workingDirectoryProperty) ? Paths.get(CURRENT_DIRECTORY, new String[0]).toAbsolutePath() : Paths.get(workingDirectoryProperty, new String[0]).toAbsolutePath();
        return workingDirectory;
    }

    private Path getResolvedDirectory(BootstrapProperty bootstrapProperty, String relativeDirectory) {
        Path resolvedDirectory;
        String directoryProperty = this.bootstrapProperties.getProperty(bootstrapProperty.getProperty());
        if (this.isEmpty(directoryProperty)) {
            Path applicationHome = this.getApplicationHome();
            resolvedDirectory = applicationHome.resolve(relativeDirectory);
        } else {
            Path directoryPropertyResolved = Paths.get(directoryProperty, new String[0]);
            if (directoryPropertyResolved.isAbsolute()) {
                resolvedDirectory = directoryPropertyResolved;
            } else {
                Path workingDirectory = this.getWorkingDirectory();
                resolvedDirectory = workingDirectory.resolve(directoryPropertyResolved);
            }
        }
        return resolvedDirectory.normalize();
    }

    private Path getApplicationHome() {
        String applicationHomeVariable = this.environmentVariables.get(EnvironmentVariable.NIFI_HOME.name());
        if (this.isEmpty(applicationHomeVariable)) {
            throw new IllegalStateException("Application Home Environment Variable [NIFI_HOME] not configured");
        }
        Path applicationHome = Paths.get(applicationHomeVariable, new String[0]).toAbsolutePath();
        if (Files.notExists(applicationHome, new LinkOption[0])) {
            throw new IllegalStateException("Application Home [%s] not found".formatted(applicationHome));
        }
        return applicationHome;
    }

    private boolean isEmpty(String property) {
        return property == null || property.isEmpty();
    }

    private void setBootstrapProperties() {
        Path bootstrapConfiguration = this.getBootstrapConfiguration();
        try (InputStream inputStream = Files.newInputStream(bootstrapConfiguration, new OpenOption[0]);){
            this.bootstrapProperties.load(inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Bootstrap Properties [%s] loading failed".formatted(bootstrapConfiguration), e);
        }
    }
}

