/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import org.eclipse.jetty.rewrite.handler.PatternRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.Name;

public class ResponsePatternRule
extends PatternRule {
    private int _code;
    private String _message;

    public ResponsePatternRule() {
    }

    public ResponsePatternRule(@Name(value="pattern") String pattern, @Name(value="code") int code, @Name(value="message") String message) {
        super(pattern);
        this._code = code;
        this._message = message;
    }

    @Override
    public boolean isTerminating() {
        return true;
    }

    public int getCode() {
        return this._code;
    }

    public void setCode(int code) {
        this._code = code;
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    @Override
    public Rule.Handler apply(Rule.Handler input) throws IOException {
        if (this.getCode() < 100) {
            return null;
        }
        return new Rule.Handler(input){

            @Override
            protected boolean handle(Response response, Callback callback) {
                String message = ResponsePatternRule.this.getMessage();
                if (StringUtil.isBlank((String)message)) {
                    response.setStatus(ResponsePatternRule.this.getCode());
                    callback.succeeded();
                } else {
                    Response.writeError((Request)this, (Response)response, (Callback)callback, (int)ResponsePatternRule.this.getCode(), (String)message);
                }
                return true;
            }
        };
    }

    @Override
    public String toString() {
        return "%s[response:%d>%s]".formatted(super.toString(), this.getCode(), this.getMessage());
    }
}

