/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components;

import java.util.Objects;
import org.apache.nifi.components.DescribedValue;

public class AllowableValue
implements DescribedValue {
    private final String value;
    private final String displayName;
    private final String description;

    public AllowableValue(String value) {
        this(value, value);
    }

    public AllowableValue(String value, String displayName) {
        this(value, displayName, null);
    }

    public AllowableValue(String value, String displayName, String description) {
        this.value = Objects.requireNonNull(value);
        this.displayName = Objects.requireNonNull(displayName);
        this.description = description;
    }

    public static AllowableValue fromDescribedValue(DescribedValue describedValue) {
        if (describedValue instanceof AllowableValue) {
            AllowableValue allowableValue = (AllowableValue)describedValue;
            return allowableValue;
        }
        return new AllowableValue(describedValue.getValue(), describedValue.getDisplayName(), describedValue.getDescription());
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AllowableValue) {
            AllowableValue other = (AllowableValue)obj;
            return this.value.equals(other.getValue());
        }
        if (obj instanceof String) {
            return this.value.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return 23984731 + 17 * this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }
}

