/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.repository;

import java.io.Serializable;
import java.util.Properties;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.repository.RepositoryPermissions;

public class Repository
implements Serializable {
    private static final long serialVersionUID = 1312227676322136247L;
    private String id;
    private String name;
    private String host;
    private int port = -1;
    private String basedir;
    private String protocol;
    private String url;
    private RepositoryPermissions permissions;
    private Properties parameters = new Properties();
    private String username = null;
    private String password = null;

    public Repository() {
    }

    public Repository(String id, String url) {
        this.setId(id);
        this.setUrl(url);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUrl(String url) {
        String username;
        this.url = url;
        this.protocol = PathUtils.protocol(url);
        this.host = PathUtils.host(url);
        this.port = PathUtils.port(url);
        this.basedir = PathUtils.basedir(url);
        this.username = username = PathUtils.user(url);
        if (username != null) {
            String password = PathUtils.password(url);
            if (password != null) {
                this.password = password;
                username = username + ":" + password;
            }
            username = username + "@";
            int index = url.indexOf(username);
            this.url = url.substring(0, index) + url.substring(index + username.length());
        }
    }

    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.protocol);
        sb.append("://");
        sb.append(this.host);
        if (this.port != -1) {
            sb.append(":");
            sb.append(this.port);
        }
        sb.append(this.basedir);
        return sb.toString();
    }

    public String getHost() {
        if (this.host == null) {
            return "localhost";
        }
        return this.host;
    }

    public String getName() {
        if (this.name == null) {
            return this.getId();
        }
        return this.name;
    }

    public String toString() {
        if (this.getName() != null) {
            return "[" + this.getName() + "] -> " + this.getUrl();
        }
        return this.getUrl();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public RepositoryPermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(RepositoryPermissions permissions) {
        this.permissions = permissions;
    }

    public String getParameter(String key) {
        return this.parameters.getProperty(key);
    }

    public void setParameters(Properties parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof Repository && ((Repository)other).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

