/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto;

import java.net.URI;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.html.annotation.HtmlLink;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.serializer.SerializeException;

@HtmlLink
@Bean(fluentSetters=true)
public class LinkString
implements Comparable<LinkString> {
    private String name;
    private URI uri;

    public LinkString() {
    }

    public LinkString(String name, String uri, Object ... uriArgs) {
        this.name(name);
        this.uri(uri, uriArgs);
    }

    public String getName() {
        return this.name;
    }

    public LinkString name(String name) {
        this.name = name;
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public LinkString uri(String uri) {
        this.uri(uri, new Object[0]);
        return this;
    }

    public LinkString uri(String uri, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            try {
                args[i] = OpenApiSerializer.DEFAULT.createSession().serialize(HttpPartType.PATH, null, args[i]);
                continue;
            }
            catch (SchemaValidationException | SerializeException e) {
                throw new RuntimeException(e);
            }
        }
        this.uri = URI.create(StringUtils.format((String)uri, (Object[])args));
        return this;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(LinkString o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LinkString)) {
            return false;
        }
        return this.compareTo((LinkString)o) == 0;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

