/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.Setter;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.Position;
import org.apache.juneau.transform.PojoSwap;

public abstract class ParserSession
extends BeanSession {
    private final Parser ctx;
    private final Method javaMethod;
    private final Object outer;
    private BeanPropertyMeta currentProperty;
    private ClassMeta<?> currentClass;
    private final ParserListener listener;
    private Position mark = new Position(-1);
    private ParserPipe pipe;

    protected ParserSession(Parser ctx, ParserSessionArgs args) {
        super(ctx, args == null ? ParserSessionArgs.DEFAULT : args);
        args = args == null ? ParserSessionArgs.DEFAULT : args;
        this.ctx = ctx;
        this.javaMethod = args.javaMethod;
        this.outer = args.outer;
        this.listener = this.getInstanceProperty("Parser.listener.c", ParserListener.class, ctx.getListener());
    }

    protected ParserSession(ParserSessionArgs args) {
        this(Parser.DEFAULT, args);
    }

    protected abstract <T> T doParse(ParserPipe var1, ClassMeta<T> var2) throws IOException, ParseException, ExecutableException;

    public abstract boolean isReaderParser();

    protected ParserPipe createPipe(Object input) {
        return null;
    }

    public final ObjectMap getLastLocation() {
        ObjectMap m = new ObjectMap();
        if (this.currentClass != null) {
            m.put("currentClass", this.currentClass.toString(true));
        }
        if (this.currentProperty != null) {
            m.put("currentProperty", this.currentProperty);
        }
        return m;
    }

    protected final Method getJavaMethod() {
        return this.javaMethod;
    }

    protected final Object getOuter() {
        return this.outer;
    }

    protected final void setCurrentProperty(BeanPropertyMeta currentProperty) {
        this.currentProperty = currentProperty;
    }

    protected final void setCurrentClass(ClassMeta<?> currentClass) {
        this.currentClass = currentClass;
    }

    protected final <K> K trim(K o) {
        if (this.isTrimStrings() && o instanceof String) {
            return (K)o.toString().trim();
        }
        return o;
    }

    protected final String trim(String s) {
        if (this.isTrimStrings() && s != null) {
            return s.trim();
        }
        return s;
    }

    protected final Object cast(ObjectMap m, BeanPropertyMeta pMeta, ClassMeta<?> eType) {
        String btpn = this.getBeanTypePropertyName(eType);
        Object o = m.get(btpn);
        if (o == null) {
            return m;
        }
        String typeName = o.toString();
        ClassMeta<?> cm = this.getClassMeta(typeName, pMeta, eType);
        if (cm != null) {
            BeanMap<?> bm = m.getBeanSession().newBeanMap(cm.getInnerClass());
            for (Map.Entry<String, Object> e : m.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                if (k.equals(btpn)) continue;
                if (v instanceof ObjectMap) {
                    v = this.cast((ObjectMap)v, pMeta, eType);
                }
                bm.put(k, v);
            }
            return bm.getBean();
        }
        return m;
    }

    protected final ClassMeta<?> getClassMeta(String typeName, BeanPropertyMeta pMeta, ClassMeta<?> eType) {
        BeanRegistry br = null;
        if (pMeta != null && (br = pMeta.getBeanRegistry()) != null && br.hasName(typeName)) {
            return br.getClassMeta(typeName);
        }
        if (eType != null && (br = eType.getBeanRegistry()) != null && br.hasName(typeName)) {
            return br.getClassMeta(typeName);
        }
        return this.getBeanRegistry().getClassMeta(typeName);
    }

    protected final <T> void onUnknownProperty(String propertyName, BeanMap<T> beanMap) throws ParseException {
        if (propertyName.equals(this.getBeanTypePropertyName(beanMap.getClassMeta()))) {
            return;
        }
        if (!this.isIgnoreUnknownBeanProperties()) {
            throw new ParseException(this, "Unknown property ''{0}'' encountered while trying to parse into class ''{1}''", propertyName, beanMap.getClassMeta());
        }
        if (this.listener != null) {
            this.listener.onUnknownBeanProperty(this, propertyName, beanMap.getClassMeta().getInnerClass(), beanMap.getBean());
        }
    }

    public final <T> T parse(Object input, Type type, Type ... args) throws ParseException, IOException {
        try (ParserPipe pipe = this.createPipe(input);){
            Object t = this.parseInner(pipe, this.getClassMeta(type, args));
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T parse(String input, Type type, Type ... args) throws ParseException {
        try (ParserPipe pipe = this.createPipe(input);){
            Object t = this.parseInner(pipe, this.getClassMeta(type, args));
            return t;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public final <T> T parse(Object input, Class<T> type) throws ParseException, IOException {
        try (ParserPipe pipe = this.createPipe(input);){
            T t = this.parseInner(pipe, this.getClassMeta(type));
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T parse(String input, Class<T> type) throws ParseException {
        try (ParserPipe pipe = this.createPipe(input);){
            T t = this.parseInner(pipe, this.getClassMeta(type));
            return t;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public final <T> T parse(Object input, ClassMeta<T> type) throws ParseException, IOException {
        try (ParserPipe pipe = this.createPipe(input);){
            T t = this.parseInner(pipe, type);
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T parse(String input, ClassMeta<T> type) throws ParseException {
        try (ParserPipe pipe = this.createPipe(input);){
            T t = this.parseInner(pipe, type);
            return t;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    private <T> T parseInner(ParserPipe pipe, ClassMeta<T> type) throws ParseException, IOException {
        if (type.isVoid()) {
            return null;
        }
        try {
            T t = this.doParse(pipe, type);
            return t;
        }
        catch (IOException | ParseException e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw new ParseException(this, "Depth too deep.  Stack overflow occurred.", new Object[0]);
        }
        catch (Exception e) {
            throw new ParseException(this, (Throwable)e, "Exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage());
        }
        finally {
            this.checkForWarnings();
        }
    }

    public final <K, V> Map<K, V> parseIntoMap(Object input, Map<K, V> m, Type keyType, Type valueType) throws ParseException {
        try {
            ParserPipe pipe = this.createPipe(input);
            try {
                Map<K, V> map = this.doParseIntoMap(pipe, m, keyType, valueType);
                if (pipe != null) {
                    pipe.close();
                }
                return map;
            }
            catch (Throwable throwable) {
                try {
                    if (pipe != null) {
                        try {
                            pipe.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ParseException(this, e);
                }
            }
        }
        finally {
            this.checkForWarnings();
        }
    }

    protected <K, V> Map<K, V> doParseIntoMap(ParserPipe pipe, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        throw new UnsupportedOperationException("Parser '" + this.getClass().getName() + "' does not support this method.");
    }

    public final <E> Collection<E> parseIntoCollection(Object input, Collection<E> c, Type elementType) throws ParseException {
        try {
            ParserPipe pipe = this.createPipe(input);
            try {
                Collection<E> collection = this.doParseIntoCollection(pipe, c, elementType);
                if (pipe != null) {
                    pipe.close();
                }
                return collection;
            }
            catch (Throwable throwable) {
                try {
                    if (pipe != null) {
                        try {
                            pipe.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException e) {
                    throw e;
                }
                catch (StackOverflowError e) {
                    throw new ParseException(this, "Depth too deep.  Stack overflow occurred.", new Object[0]);
                }
                catch (IOException e) {
                    throw new ParseException(this, (Throwable)e, "I/O exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage());
                }
                catch (Exception e) {
                    throw new ParseException(this, (Throwable)e, "Exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage());
                }
            }
        }
        finally {
            this.checkForWarnings();
        }
    }

    protected <E> Collection<E> doParseIntoCollection(ParserPipe pipe, Collection<E> c, Type elementType) throws Exception {
        throw new UnsupportedOperationException("Parser '" + this.getClass().getName() + "' does not support this method.");
    }

    public final Object[] parseArgs(Object input, Type[] argTypes) throws ParseException {
        try {
            ParserPipe pipe = this.createPipe(input);
            try {
                Object[] objectArray = this.doParse(pipe, this.getArgsClassMeta(argTypes));
                if (pipe != null) {
                    pipe.close();
                }
                return objectArray;
            }
            catch (Throwable throwable) {
                try {
                    if (pipe != null) {
                        try {
                            pipe.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException e) {
                    throw e;
                }
                catch (StackOverflowError e) {
                    throw new ParseException(this, "Depth too deep.  Stack overflow occurred.", new Object[0]);
                }
                catch (IOException e) {
                    throw new ParseException(this, (Throwable)e, "I/O exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage());
                }
                catch (Exception e) {
                    throw new ParseException(this, (Throwable)e, "Exception occurred.  exception={0}, message={1}.", e.getClass().getSimpleName(), e.getLocalizedMessage());
                }
            }
        }
        finally {
            this.checkForWarnings();
        }
    }

    protected final <T> T convertAttrToType(Object outer, String s, ClassMeta<T> type) throws IOException, ParseException, ExecutableException {
        PojoSwap<T, ?> swap;
        if (s == null) {
            return null;
        }
        if (type == null) {
            type = this.object();
        }
        ClassMeta<Object> sType = (swap = type.getPojoSwap(this)) == null ? type : swap.getSwapClassMeta(this);
        Object o = s;
        if (sType.isChar()) {
            o = StringUtils.parseCharacter(s);
        } else if (sType.isNumber()) {
            o = StringUtils.parseNumber(s, sType.getInnerClass());
        } else if (sType.isBoolean()) {
            o = Boolean.parseBoolean(s);
        } else if (!sType.isCharSequence() && !sType.isObject()) {
            if (sType.canCreateNewInstanceFromString(outer)) {
                o = sType.newInstanceFromString(outer, s);
            } else {
                throw new ParseException(this, "Invalid conversion from string to class ''{0}''", type);
            }
        }
        if (swap != null) {
            o = this.unswap(swap, o, type);
        }
        return (T)o;
    }

    protected static final void setParent(ClassMeta<?> cm, Object o, Object parent) throws ExecutableException {
        Setter m = cm.getParentProperty();
        if (m != null) {
            m.set(o, parent);
        }
    }

    protected static final void setName(ClassMeta<?> cm, Object o, Object name) throws ExecutableException {
        Setter m;
        if (cm != null && (m = cm.getNameProperty()) != null) {
            m.set(o, name);
        }
    }

    public <T extends ParserListener> T getListener(Class<T> c) {
        return (T)this.listener;
    }

    protected ParserPipe setPipe(ParserPipe pipe) {
        this.pipe = pipe;
        return pipe;
    }

    public Position getPosition() {
        if (this.mark.line != -1 || this.mark.column != -1 || this.mark.position != -1) {
            return this.mark;
        }
        if (this.pipe == null) {
            return Position.UNKNOWN;
        }
        return this.pipe.getPosition();
    }

    protected void mark() {
        if (this.pipe != null) {
            Position p = this.pipe.getPosition();
            this.mark.line = p.line;
            this.mark.column = p.column;
            this.mark.position = p.position;
        }
    }

    protected void unmark() {
        this.mark.line = -1;
        this.mark.column = -1;
        this.mark.position = -1;
    }

    public String getInputAsString() {
        return this.pipe == null ? null : this.pipe.getInputAsString();
    }

    protected Object unswap(PojoSwap swap, Object o, ClassMeta<?> eType) throws ParseException {
        try {
            return swap.unswap(this, o, eType);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    protected final boolean isAutoCloseStreams() {
        return this.ctx.isAutoCloseStreams();
    }

    protected final int getDebugOutputLines() {
        return this.ctx.getDebugOutputLines();
    }

    public ParserListener getListener() {
        return this.listener;
    }

    protected final boolean isStrict() {
        return this.ctx.isStrict();
    }

    protected final boolean isTrimStrings() {
        return this.ctx.isTrimStrings();
    }

    protected final boolean isUnbuffered() {
        return this.ctx.isUnbuffered();
    }

    protected final Class<? extends ParserListener> getListenerClass() {
        return this.ctx.getListener();
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append("ParserSession", new DefaultFilteringObjectMap().append("javaMethod", this.javaMethod).append("listener", this.listener).append("outer", this.outer));
    }
}

