/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.io.IOException;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMapEntry;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.Delegate;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.html.AnchorText;
import org.apache.juneau.html.HtmlBeanPropertyMeta;
import org.apache.juneau.html.HtmlClassMeta;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.html.annotation.HtmlLink;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xml.XmlWriter;
import org.apache.juneau.xml.annotation.XmlFormat;

public class HtmlSerializerSession
extends XmlSerializerSession {
    private final HtmlSerializer ctx;
    private final Pattern urlPattern = Pattern.compile("http[s]?\\:\\/\\/.*");
    private final Pattern labelPattern;

    protected HtmlSerializerSession(HtmlSerializer ctx, SerializerSessionArgs args) {
        super(ctx, args);
        this.ctx = ctx;
        this.labelPattern = Pattern.compile("[\\?\\&]" + Pattern.quote(ctx.getLabelParameter()) + "=([^\\&]*)");
    }

    protected final HtmlWriter getHtmlWriter(SerializerPipe out) throws IOException {
        Object output = out.getRawOutput();
        if (output instanceof HtmlWriter) {
            return (HtmlWriter)output;
        }
        HtmlWriter w = new HtmlWriter(out.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.isTrimStrings(), this.getQuoteChar(), this.getUriResolver());
        out.setWriter(w);
        return w;
    }

    public boolean isUri(ClassMeta<?> cm, BeanPropertyMeta pMeta, Object o) {
        if (cm.isUri()) {
            return true;
        }
        if (pMeta != null && pMeta.isUri()) {
            return true;
        }
        return this.isDetectLinksInStrings() && o instanceof CharSequence && this.urlPattern.matcher(o.toString()).matches();
    }

    public String getAnchorText(BeanPropertyMeta pMeta, Object o) {
        Matcher m;
        String s = o.toString();
        if (this.isDetectLabelParameters() && (m = this.labelPattern.matcher(s)).find()) {
            return StringUtils.urlDecode(m.group(1));
        }
        switch (this.getUriAnchorText()) {
            case LAST_TOKEN: {
                s = this.resolveUri(s);
                if (s.indexOf(47) != -1) {
                    s = s.substring(s.lastIndexOf(47) + 1);
                }
                if (s.indexOf(63) != -1) {
                    s = s.substring(0, s.indexOf(63));
                }
                if (s.indexOf(35) != -1) {
                    s = s.substring(0, s.indexOf(35));
                }
                if (s.isEmpty()) {
                    s = "/";
                }
                return StringUtils.urlDecode(s);
            }
            case URI_ANCHOR: {
                if (s.indexOf(35) != -1) {
                    s = s.substring(s.lastIndexOf(35) + 1);
                }
                return StringUtils.urlDecode(s);
            }
            case PROPERTY_NAME: {
                return pMeta == null ? s : pMeta.getName();
            }
            case URI: {
                return this.resolveUri(s);
            }
            case CONTEXT_RELATIVE: {
                return this.relativizeUri("context:/", s);
            }
            case SERVLET_RELATIVE: {
                return this.relativizeUri("servlet:/", s);
            }
            case PATH_RELATIVE: {
                return this.relativizeUri("request:/", s);
            }
        }
        return s;
    }

    @Override
    public boolean isHtmlMode() {
        return true;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        this.doSerialize(o, this.getHtmlWriter(out));
    }

    private XmlWriter doSerialize(Object o, XmlWriter w) throws IOException, SerializeException {
        this.serializeAnything(w, o, this.getExpectedRootType(o), null, null, this.getInitialDepth() - 1, true, false);
        return w;
    }

    @Override
    protected XmlSerializerSession.ContentResult serializeAnything(XmlWriter out, Object o, ClassMeta<?> eType, String elementName, Namespace elementNamespace, boolean addNamespaceUris, XmlFormat format, boolean isMixed, boolean preserveWhitespace, BeanPropertyMeta pMeta) throws IOException, SerializeException {
        ClassMeta<Object> type = this.push2(elementName, o, eType);
        this.pop();
        if (type == null) {
            type = this.object();
        } else if (type.isDelegate()) {
            type = ((Delegate)o).getClassMeta();
        }
        PojoSwap<Object, ?> swap = type.getPojoSwap(this);
        if (swap != null) {
            o = this.swap(swap, o);
            type = swap.getSwapClassMeta(this);
            if (type.isObject()) {
                type = this.getClassMetaForObject(o);
            }
        }
        HtmlClassMeta cHtml = this.getHtmlClassMeta(type);
        if (type.isMapOrBean() && !cHtml.isXml()) {
            return this.serializeAnything(out, o, eType, elementName, pMeta, 0, false, false);
        }
        return super.serializeAnything(out, o, eType, elementName, elementNamespace, addNamespaceUris, format, isMixed, preserveWhitespace, pMeta);
    }

    protected XmlSerializerSession.ContentResult serializeAnything(XmlWriter out, Object o, ClassMeta<?> eType, String name, BeanPropertyMeta pMeta, int xIndent, boolean isRoot, boolean nlIfElement) throws IOException, SerializeException {
        ClassMeta<Object> aType = null;
        ClassMeta<Object> wType = null;
        ClassMeta<Object> sType = this.object();
        if (eType == null) {
            eType = this.object();
        }
        if ((aType = this.push2(name, o, eType)) == null) {
            o = null;
            aType = this.object();
        }
        if (this.isOptional(aType)) {
            o = this.getOptionalValue(o);
            eType = this.getOptionalType(eType);
            aType = this.getClassMetaForObject(o, this.object());
        }
        this.indent += xIndent;
        XmlSerializerSession.ContentResult cr = XmlSerializerSession.ContentResult.CR_ELEMENTS;
        if (o == null || aType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.tag("null");
            cr = XmlSerializerSession.ContentResult.CR_MIXED;
        } else {
            Object o2;
            PojoSwap<Object, ?> swap;
            if (aType.isDelegate()) {
                wType = aType;
                aType = ((Delegate)o).getClassMeta();
            }
            sType = aType;
            String typeName = null;
            if (this.isAddBeanTypes() && !eType.equals(aType)) {
                typeName = aType.getDictionaryName();
            }
            if ((swap = aType.getPojoSwap(this)) != null) {
                o = this.swap(swap, o);
                sType = swap.getSwapClassMeta(this);
                if (sType.isObject()) {
                    sType = this.getClassMetaForObject(o);
                }
            }
            if (sType.isReader() || sType.isInputStream()) {
                this.pop();
                this.indent -= xIndent;
                IOUtils.pipe(o, out);
                return XmlSerializerSession.ContentResult.CR_MIXED;
            }
            HtmlClassMeta cHtml = this.getHtmlClassMeta(sType);
            HtmlBeanPropertyMeta bpHtml = this.getHtmlBeanPropertyMeta(pMeta);
            HtmlRender render = ObjectUtils.firstNonNull(bpHtml.getRender(), cHtml.getRender());
            if (render != null && (o2 = render.getContent(this, o)) != o) {
                this.indent -= xIndent;
                this.pop();
                out.nl(this.indent);
                return this.serializeAnything(out, o2, null, typeName, null, xIndent, false, false);
            }
            if (cHtml.isXml() || bpHtml.isXml()) {
                this.pop();
                ++this.indent;
                if (nlIfElement) {
                    out.nl(0);
                }
                super.serializeAnything(out, o, null, null, null, false, XmlFormat.MIXED, false, false, null);
                this.indent -= xIndent + 1;
                return cr;
            }
            if (cHtml.isPlainText() || bpHtml.isPlainText()) {
                out.write(o == null ? "null" : o.toString());
                cr = XmlSerializerSession.ContentResult.CR_MIXED;
            } else if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
                out.tag("null");
                cr = XmlSerializerSession.ContentResult.CR_MIXED;
            } else if (sType.isNumber()) {
                if (eType.isNumber() && !isRoot) {
                    out.append(o);
                } else {
                    out.sTag("number").append(o).eTag("number");
                }
                cr = XmlSerializerSession.ContentResult.CR_MIXED;
            } else if (sType.isBoolean()) {
                if (eType.isBoolean() && !isRoot) {
                    out.append(o);
                } else {
                    out.sTag("boolean").append(o).eTag("boolean");
                }
                cr = XmlSerializerSession.ContentResult.CR_MIXED;
            } else if (sType.isMap() || wType != null && wType.isMap()) {
                out.nlIf(!isRoot, xIndent + 1);
                if (o instanceof BeanMap) {
                    this.serializeBeanMap(out, (BeanMap)o, eType, pMeta);
                } else {
                    this.serializeMap(out, (Map)o, sType, eType.getKeyType(), eType.getValueType(), typeName, pMeta);
                }
            } else if (sType.isBean()) {
                BeanMap<Object> m = this.toBeanMap(o);
                if (aType.hasAnnotation(HtmlLink.class)) {
                    HtmlLink h = aType.getAnnotation(HtmlLink.class);
                    Object urlProp = m.get(h.uriProperty());
                    Object nameProp = m.get(h.nameProperty());
                    out.oTag("a").attrUri("href", urlProp).append('>').text(nameProp).eTag("a");
                    cr = XmlSerializerSession.ContentResult.CR_MIXED;
                } else {
                    out.nlIf(!isRoot, xIndent + 2);
                    this.serializeBeanMap(out, m, eType, pMeta);
                }
            } else if (sType.isCollection() || sType.isArray() || wType != null && wType.isCollection()) {
                out.nlIf(!isRoot, xIndent + 1);
                this.serializeCollection(out, o, sType, eType, name, pMeta);
            } else if (this.isUri(sType, pMeta, o)) {
                String label = this.getAnchorText(pMeta, o);
                out.oTag("a").attrUri("href", o).append('>');
                out.text(label);
                out.eTag("a");
                cr = XmlSerializerSession.ContentResult.CR_MIXED;
            } else {
                if (isRoot) {
                    out.sTag("string").text(this.toString(o)).eTag("string");
                } else {
                    out.text(this.toString(o));
                }
                cr = XmlSerializerSession.ContentResult.CR_MIXED;
            }
        }
        this.pop();
        this.indent -= xIndent;
        return cr;
    }

    private void serializeMap(XmlWriter out, Map m, ClassMeta<?> sType, ClassMeta<?> eKeyType, ClassMeta<?> eValueType, String typeName, BeanPropertyMeta ppMeta) throws IOException, SerializeException {
        ClassMeta<Object> keyType = eKeyType == null ? this.string() : eKeyType;
        ClassMeta<Object> valueType = eValueType == null ? this.object() : eValueType;
        ClassMeta<Map> aType = this.getClassMetaForObject(m);
        HtmlClassMeta cHtml = this.getHtmlClassMeta(aType);
        HtmlBeanPropertyMeta bpHtml = this.getHtmlBeanPropertyMeta(ppMeta);
        int i = this.indent;
        out.oTag(i, "table");
        if (typeName != null && ppMeta != null && ppMeta.getClassMeta() != aType) {
            out.attr(this.getBeanTypePropertyName(sType), typeName);
        }
        out.append(">").nl(i + 1);
        if (this.isAddKeyValueTableHeaders() && !cHtml.isNoTableHeaders() && !bpHtml.isNoTableHeaders()) {
            out.sTag(i + 1, "tr").nl(i + 2);
            out.sTag(i + 2, "th").append("key").eTag("th").nl(i + 3);
            out.sTag(i + 2, "th").append("value").eTag("th").nl(i + 3);
            out.ie(i + 1).eTag("tr").nl(i + 2);
        }
        for (Map.Entry e : m.entrySet()) {
            Object key = this.generalize(e.getKey(), keyType);
            Object value = null;
            try {
                value = e.getValue();
            }
            catch (StackOverflowError t) {
                throw t;
            }
            catch (Throwable t) {
                this.onError(t, "Could not call getValue() on property ''{0}'', {1}", e.getKey(), t.getLocalizedMessage());
            }
            String link = this.getLink(ppMeta);
            String style = this.getStyle(this, ppMeta, value);
            out.sTag(i + 1, "tr").nl(i + 2);
            out.oTag(i + 2, "td");
            if (style != null) {
                out.attr("style", style);
            }
            out.cTag();
            if (link != null) {
                out.oTag(i + 3, "a").attrUri("href", link.replace("{#}", StringUtils.stringify(value))).cTag();
            }
            XmlSerializerSession.ContentResult cr = this.serializeAnything(out, key, keyType, null, null, 2, false, false);
            if (link != null) {
                out.eTag("a");
            }
            if (cr == XmlSerializerSession.ContentResult.CR_ELEMENTS) {
                out.i(i + 2);
            }
            out.eTag("td").nl(i + 2);
            out.sTag(i + 2, "td");
            cr = this.serializeAnything(out, value, valueType, key == null ? "_x0000_" : this.toString(key), null, 2, false, false);
            if (cr == XmlSerializerSession.ContentResult.CR_ELEMENTS) {
                out.ie(i + 2);
            }
            out.eTag("td").nl(i + 2);
            out.ie(i + 1).eTag("tr").nl(i + 1);
        }
        out.ie(i).eTag("table").nl(i);
    }

    private void serializeBeanMap(XmlWriter out, BeanMap<?> m, ClassMeta<?> eType, BeanPropertyMeta ppMeta) throws IOException, SerializeException {
        HtmlClassMeta cHtml = this.getHtmlClassMeta(m.getClassMeta());
        HtmlBeanPropertyMeta bpHtml = this.getHtmlBeanPropertyMeta(ppMeta);
        int i = this.indent;
        out.oTag(i, "table");
        String typeName = m.getMeta().getDictionaryName();
        if (typeName != null && eType != m.getClassMeta()) {
            out.attr(this.getBeanTypePropertyName(m.getClassMeta()), typeName);
        }
        out.append('>').nl(i);
        if (this.isAddKeyValueTableHeaders() && !cHtml.isNoTableHeaders() && !bpHtml.isNoTableHeaders()) {
            out.sTag(i + 1, "tr").nl(i + 1);
            out.sTag(i + 2, "th").append("key").eTag("th").nl(i + 2);
            out.sTag(i + 2, "th").append("value").eTag("th").nl(i + 2);
            out.ie(i + 1).eTag("tr").nl(i + 1);
        }
        for (BeanPropertyValue p : m.getValues(this.isTrimNullProperties(), new BeanPropertyValue[0])) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                this.onBeanGetterException(pMeta, t);
            }
            if (this.canIgnoreValue(cMeta, key, value)) continue;
            String link = null;
            String anchorText = null;
            if (!cMeta.isCollectionOrArray()) {
                link = m.resolveVars(this.getLink(pMeta));
                anchorText = m.resolveVars(this.getAnchorText(pMeta));
            }
            if (anchorText != null) {
                value = anchorText;
            }
            out.sTag(i + 1, "tr").nl(i + 1);
            out.sTag(i + 2, "td").text(key).eTag("td").nl(i + 2);
            out.oTag(i + 2, "td");
            String style = this.getStyle(this, pMeta, value);
            if (style != null) {
                out.attr("style", style);
            }
            out.cTag();
            try {
                XmlSerializerSession.ContentResult cr;
                if (link != null) {
                    out.oTag(i + 3, "a").attrUri("href", link).cTag();
                }
                if ((cr = this.serializeAnything(out, value, cMeta, key, pMeta, 2, false, true)) == XmlSerializerSession.ContentResult.CR_ELEMENTS) {
                    out.i(i + 2);
                }
                if (link != null) {
                    out.eTag("a");
                }
            }
            catch (SerializeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.onBeanGetterException(pMeta, e);
            }
            out.eTag("td").nl(i + 2);
            out.ie(i + 1).eTag("tr").nl(i + 1);
        }
        out.ie(i).eTag("table").nl(i);
    }

    /*
     * WARNING - void declaration
     */
    private void serializeCollection(XmlWriter out, Object in, ClassMeta<?> sType, ClassMeta<?> eType, String name, BeanPropertyMeta ppMeta) throws IOException, SerializeException {
        HtmlClassMeta cHtml = this.getHtmlClassMeta(sType);
        HtmlBeanPropertyMeta bpHtml = this.getHtmlBeanPropertyMeta(ppMeta);
        Collection<Object> c = sType.isCollection() ? (List<Object>)in : HtmlSerializerSession.toList(sType.getInnerClass(), in);
        boolean isCdc = cHtml.isHtmlCdc() || bpHtml.isHtmlCdc();
        boolean isSdc = cHtml.isHtmlSdc() || bpHtml.isHtmlSdc();
        boolean isDc = isCdc || isSdc;
        int i = this.indent;
        if (c.isEmpty()) {
            out.appendln(i, "<ul></ul>");
            return;
        }
        String type2 = null;
        if (sType != eType) {
            type2 = sType.getDictionaryName();
        }
        if (type2 == null) {
            type2 = "array";
        }
        c = this.sort(c);
        String btpn = this.getBeanTypePropertyName(eType);
        Object[] th = this.getTableHeaders(c, bpHtml);
        if (th != null) {
            out.oTag(i, "table").attr(btpn, type2).append('>').nl(i + 1);
            out.sTag(i + 1, "tr").nl(i + 2);
            for (Object key : th) {
                out.sTag(i + 2, "th");
                out.text(this.convertToType(key, String.class));
                out.eTag("th").nl(i + 2);
            }
            out.ie(i + 1).eTag("tr").nl(i + 1);
            for (Object e : c) {
                BeanMap<void> m2;
                void var18_22;
                ClassMeta<Object> cm = this.getClassMetaForObject(e);
                if (cm != null && cm.getPojoSwap(this) != null) {
                    PojoSwap swap = cm.getPojoSwap(this);
                    Object object = this.swap(swap, e);
                    cm = swap.getSwapClassMeta(this);
                }
                out.oTag(i + 1, "tr");
                String typeName = cm == null ? null : cm.getDictionaryName();
                String typeProperty = this.getBeanTypePropertyName(cm);
                if (typeName != null && eType.getElementType() != cm) {
                    out.attr(typeProperty, typeName);
                }
                out.cTag().nl(i + 2);
                if (cm == null) {
                    out.i(i + 2);
                    this.serializeAnything(out, var18_22, null, null, null, 1, false, false);
                    out.nl(0);
                } else if (cm.isMap() && !cm.isBeanMap()) {
                    m2 = this.sort((Map)var18_22);
                    for (Object k : th) {
                        out.sTag(i + 2, "td");
                        XmlSerializerSession.ContentResult cr = this.serializeAnything(out, m2.get(k), eType.getElementType(), this.toString(k), null, 2, false, true);
                        if (cr == XmlSerializerSession.ContentResult.CR_ELEMENTS) {
                            out.i(i + 2);
                        }
                        out.eTag("td").nl(i + 2);
                    }
                } else {
                    m2 = null;
                    m2 = var18_22 instanceof BeanMap ? (BeanMap<void>)var18_22 : this.toBeanMap(var18_22);
                    for (Object k : th) {
                        XmlSerializerSession.ContentResult cr;
                        BeanMapEntry p = m2.getProperty(this.toString(k));
                        BeanPropertyMeta pMeta = p.getMeta();
                        if (!pMeta.canRead()) continue;
                        Object value = p.getValue();
                        String link = null;
                        String anchorText = null;
                        if (!pMeta.getClassMeta().isCollectionOrArray()) {
                            link = m2.resolveVars(this.getLink(pMeta));
                            anchorText = m2.resolveVars(this.getAnchorText(pMeta));
                        }
                        if (anchorText != null) {
                            value = anchorText;
                        }
                        String style = this.getStyle(this, pMeta, value);
                        out.oTag(i + 2, "td");
                        if (style != null) {
                            out.attr("style", style);
                        }
                        out.cTag();
                        if (link != null) {
                            out.oTag("a").attrUri("href", link).cTag();
                        }
                        if ((cr = this.serializeAnything(out, value, pMeta.getClassMeta(), p.getKey().toString(), pMeta, 2, false, true)) == XmlSerializerSession.ContentResult.CR_ELEMENTS) {
                            out.i(i + 2);
                        }
                        if (link != null) {
                            out.eTag("a");
                        }
                        out.eTag("td").nl(i + 2);
                    }
                }
                out.ie(i + 1).eTag("tr").nl(i + 1);
            }
            out.ie(i).eTag("table").nl(i);
        } else {
            out.oTag(i, isDc ? "p" : "ul");
            if (!type2.equals("array")) {
                out.attr(btpn, type2);
            }
            out.append('>').nl(i + 1);
            boolean isFirst = true;
            for (Object o : c) {
                if (isDc && !isFirst) {
                    out.append(isCdc ? ", " : " ");
                }
                if (!isDc) {
                    out.oTag(i + 1, "li");
                }
                String style = this.getStyle(this, ppMeta, o);
                String link = this.getLink(ppMeta);
                if (style != null && !isDc) {
                    out.attr("style", style);
                }
                if (!isDc) {
                    out.cTag();
                }
                if (link != null) {
                    out.oTag(i + 2, "a").attrUri("href", link.replace("{#}", StringUtils.stringify(o))).cTag();
                }
                XmlSerializerSession.ContentResult cr = this.serializeAnything(out, o, eType.getElementType(), name, null, 1, false, true);
                if (link != null) {
                    out.eTag("a");
                }
                if (cr == XmlSerializerSession.ContentResult.CR_ELEMENTS) {
                    out.ie(i + 1);
                }
                if (!isDc) {
                    out.eTag("li").nl(i + 1);
                }
                isFirst = false;
            }
            out.ie(i).eTag(isDc ? "p" : "ul").nl(i);
        }
    }

    private HtmlRender<?> getRender(HtmlSerializerSession session, BeanPropertyMeta pMeta, Object value) {
        if (pMeta == null) {
            return null;
        }
        HtmlRender render = this.getHtmlBeanPropertyMeta(pMeta).getRender();
        if (render != null) {
            return render;
        }
        ClassMeta<Object> cMeta = session.getClassMetaForObject(value);
        render = cMeta == null ? null : this.getHtmlClassMeta(cMeta).getRender();
        return render;
    }

    private String getStyle(HtmlSerializerSession session, BeanPropertyMeta pMeta, Object value) {
        HtmlRender<?> render = this.getRender(session, pMeta, value);
        return render == null ? null : render.getStyle(session, value);
    }

    private String getLink(BeanPropertyMeta pMeta) {
        return pMeta == null ? null : this.getHtmlBeanPropertyMeta(pMeta).getLink();
    }

    private String getAnchorText(BeanPropertyMeta pMeta) {
        return pMeta == null ? null : this.getHtmlBeanPropertyMeta(pMeta).getAnchorText();
    }

    private Object[] getTableHeaders(Collection c, HtmlBeanPropertyMeta bpHtml) throws SerializeException {
        Object[] th;
        if (c.size() == 0) {
            return null;
        }
        c = this.sort(c);
        HashSet<ClassMeta<Object>> prevC = new HashSet<ClassMeta<Object>>();
        Object o1 = null;
        for (Object o : c) {
            if (o == null) continue;
            o1 = o;
            break;
        }
        if (o1 == null) {
            return null;
        }
        ClassMeta<Object> cm = this.getClassMetaForObject(o1);
        PojoSwap<Object, ?> swap = cm.getPojoSwap(this);
        if (swap != null) {
            o1 = this.swap(swap, o1);
            cm = swap.getSwapClassMeta(this);
        }
        if (cm == null || !cm.isMapOrBean()) {
            return null;
        }
        if (cm.hasAnnotation(HtmlLink.class)) {
            return null;
        }
        HtmlClassMeta cHtml = this.getHtmlClassMeta(cm);
        if (cHtml.isNoTables() || bpHtml.isNoTables()) {
            return null;
        }
        if (cHtml.isNoTableHeaders() || bpHtml.isNoTableHeaders()) {
            return new Object[0];
        }
        if (this.canIgnoreValue(cm, null, o1)) {
            return null;
        }
        if (cm.isMap() && !cm.isBeanMap()) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (Object o : c) {
                if (this.canIgnoreValue(cm, null, o)) continue;
                if (!cm.isInstance(o)) {
                    return null;
                }
                Map m = this.sort((Map)o);
                for (Map.Entry<String, Object> entry : m.entrySet()) {
                    if (entry.getValue() == null) continue;
                    set.add(entry.getKey() == null ? null : entry.getKey());
                }
            }
            th = set.toArray(new Object[set.size()]);
        } else {
            LinkedHashMap<String, Boolean> m = new LinkedHashMap<String, Boolean>();
            for (Object o : c) {
                if (this.canIgnoreValue(cm, null, o)) continue;
                if (!cm.isInstance(o)) {
                    return null;
                }
                BeanMap bm = o instanceof BeanMap ? (BeanMap)o : this.toBeanMap(o);
                for (Map.Entry<String, Object> entry : bm.entrySet()) {
                    String key = entry.getKey();
                    if (entry.getValue() != null) {
                        m.put(key, true);
                        continue;
                    }
                    if (m.containsKey(key)) continue;
                    m.put(key, false);
                }
            }
            Object[] i = m.values().iterator();
            while (i.hasNext()) {
                if (((Boolean)i.next()).booleanValue()) continue;
                i.remove();
            }
            th = m.keySet().toArray(new Object[m.size()]);
        }
        prevC.add(cm);
        boolean isSortable = true;
        for (Object o : th) {
            isSortable &= o instanceof Comparable;
        }
        AbstractSet s = isSortable ? new TreeSet() : new LinkedHashSet();
        s.addAll(Arrays.asList(th));
        for (Object o : c) {
            PojoSwap<Object, ?> ps;
            if (o == null) continue;
            cm = this.getClassMetaForObject(o);
            PojoSwap<Object, ?> pojoSwap = ps = cm == null ? null : cm.getPojoSwap(this);
            if (ps != null) {
                o = this.swap(ps, o);
                cm = ps.getSwapClassMeta(this);
            }
            if (prevC.contains(cm)) continue;
            if (cm == null || !cm.isMap() && !cm.isBean()) {
                return null;
            }
            if (cm.hasAnnotation(HtmlLink.class)) {
                return null;
            }
            if (this.canIgnoreValue(cm, null, o)) {
                return null;
            }
            if (cm.isMap() && !cm.isBeanMap()) {
                Map map = (Map)o;
                if (th.length != map.keySet().size()) {
                    return null;
                }
                for (Object k : map.keySet()) {
                    if (s.contains(k.toString())) continue;
                    return null;
                }
                continue;
            }
            BeanMap beanMap = o instanceof BeanMap ? (BeanMap)o : this.toBeanMap(o);
            int l = 0;
            for (String k : beanMap.keySet()) {
                if (!s.contains(k)) {
                    return null;
                }
                ++l;
            }
            if (s.size() == l) continue;
            return null;
        }
        return th;
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.ctx.isAddBeanTypes();
    }

    protected final boolean isAddKeyValueTableHeaders() {
        return this.ctx.isAddKeyValueTableHeaders();
    }

    protected final boolean isDetectLabelParameters() {
        return this.ctx.isDetectLabelParameters();
    }

    protected final boolean isDetectLinksInStrings() {
        return this.ctx.isDetectLinksInStrings();
    }

    protected final String getLabelParameter() {
        return this.ctx.getLabelParameter();
    }

    protected final AnchorText getUriAnchorText() {
        return this.ctx.getUriAnchorText();
    }

    protected HtmlClassMeta getHtmlClassMeta(ClassMeta<?> cm) {
        return this.ctx.getHtmlClassMeta(cm);
    }

    protected HtmlBeanPropertyMeta getHtmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        return this.ctx.getHtmlBeanPropertyMeta(bpm);
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append("HtmlSerializerSession", new DefaultFilteringObjectMap());
    }
}

