/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.Info;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.dto.swagger.OperationMap;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SecurityScheme;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.dto.swagger.Tag;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.utils.ASet;
import org.apache.juneau.utils.PojoRest;

@Bean(bpi="swagger,info,tags,externalDocs,basePath,schemes,consumes,produces,paths,definitions,parameters,responses,securityDefinitions,security,*")
public class Swagger
extends SwaggerElement {
    public static final Swagger NULL = new Swagger();
    private static final Comparator<String> PATH_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.replace('{', '@').compareTo(o2.replace('{', '@'));
        }
    };
    private String swagger = "2.0";
    private String host;
    private String basePath;
    private Info info;
    private ExternalDocumentation externalDocs;
    private List<String> schemes;
    private List<MediaType> consumes;
    private List<MediaType> produces;
    private List<Tag> tags;
    private List<Map<String, List<String>>> security;
    private Map<String, ObjectMap> definitions;
    private Map<String, ParameterInfo> parameters;
    private Map<String, ResponseInfo> responses;
    private Map<String, SecurityScheme> securityDefinitions;
    private Map<String, OperationMap> paths;

    public Swagger() {
    }

    public Swagger(Swagger copyFrom) {
        super(copyFrom);
        this.swagger = copyFrom.swagger;
        this.host = copyFrom.host;
        this.basePath = copyFrom.basePath;
        this.info = copyFrom.info == null ? null : copyFrom.info.copy();
        this.externalDocs = copyFrom.externalDocs == null ? null : copyFrom.externalDocs.copy();
        this.schemes = CollectionUtils.newList(copyFrom.schemes);
        this.consumes = CollectionUtils.newList(copyFrom.consumes);
        this.produces = CollectionUtils.newList(copyFrom.produces);
        if (copyFrom.tags == null) {
            this.tags = null;
        } else {
            this.tags = new ArrayList<Tag>();
            for (Tag tag : copyFrom.tags) {
                this.tags.add(tag.copy());
            }
        }
        if (copyFrom.security == null) {
            this.security = null;
        } else {
            this.security = new ArrayList<Map<String, List<String>>>();
            for (Map map : copyFrom.security) {
                LinkedHashMap m2 = new LinkedHashMap();
                for (Map.Entry e : map.entrySet()) {
                    m2.put((String)e.getKey(), CollectionUtils.newList((Collection)e.getValue()));
                }
                this.security.add(m2);
            }
        }
        if (copyFrom.definitions == null) {
            this.definitions = null;
        } else {
            this.definitions = new LinkedHashMap<String, ObjectMap>();
            for (Map.Entry entry : copyFrom.definitions.entrySet()) {
                this.definitions.put((String)entry.getKey(), new ObjectMap((Map<?, ?>)((Map)entry.getValue())));
            }
        }
        if (copyFrom.parameters == null) {
            this.parameters = null;
        } else {
            this.parameters = new LinkedHashMap<String, ParameterInfo>();
            for (Map.Entry entry : copyFrom.parameters.entrySet()) {
                this.parameters.put((String)entry.getKey(), ((ParameterInfo)entry.getValue()).copy());
            }
        }
        if (copyFrom.responses == null) {
            this.responses = null;
        } else {
            this.responses = new LinkedHashMap<String, ResponseInfo>();
            for (Map.Entry entry : copyFrom.responses.entrySet()) {
                this.responses.put((String)entry.getKey(), ((ResponseInfo)entry.getValue()).copy());
            }
        }
        if (copyFrom.securityDefinitions == null) {
            this.securityDefinitions = null;
        } else {
            this.securityDefinitions = new LinkedHashMap<String, SecurityScheme>();
            for (Map.Entry entry : copyFrom.securityDefinitions.entrySet()) {
                this.securityDefinitions.put((String)entry.getKey(), ((SecurityScheme)entry.getValue()).copy());
            }
        }
        if (copyFrom.paths == null) {
            this.paths = null;
        } else {
            this.paths = new LinkedHashMap<String, OperationMap>();
            for (Map.Entry entry : copyFrom.paths.entrySet()) {
                OperationMap m = new OperationMap();
                for (Map.Entry e2 : ((OperationMap)entry.getValue()).entrySet()) {
                    m.put((String)e2.getKey(), ((Operation)e2.getValue()).copy());
                }
                this.paths.put((String)entry.getKey(), m);
            }
        }
    }

    public Swagger copy() {
        return new Swagger(this);
    }

    public String getSwagger() {
        return this.swagger;
    }

    public Swagger setSwagger(String value) {
        this.swagger = value;
        return this;
    }

    public Swagger swagger(Object value) {
        return this.setSwagger(StringUtils.stringify(value));
    }

    public Info getInfo() {
        return this.info;
    }

    public Swagger setInfo(Info value) {
        this.info = value;
        return this;
    }

    public Swagger info(Object value) {
        return this.setInfo(ObjectUtils.toType(value, Info.class));
    }

    public String getHost() {
        return this.host;
    }

    public Swagger setHost(String value) {
        this.host = value;
        return this;
    }

    public Swagger host(Object value) {
        return this.setHost(StringUtils.stringify(value));
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Swagger setBasePath(String value) {
        this.basePath = value;
        return this;
    }

    public Swagger basePath(Object value) {
        return this.setBasePath(StringUtils.stringify(value));
    }

    public List<String> getSchemes() {
        return this.schemes;
    }

    public Swagger setSchemes(Collection<String> value) {
        this.schemes = CollectionUtils.newList(value);
        return this;
    }

    public Swagger addSchemes(Collection<String> values) {
        this.schemes = CollectionUtils.addToList(this.schemes, values);
        return this;
    }

    public Swagger schemes(Object ... values) {
        this.schemes = CollectionUtils.addToList(this.schemes, values, String.class, new Type[0]);
        return this;
    }

    public List<MediaType> getConsumes() {
        return this.consumes;
    }

    public Swagger setConsumes(Collection<MediaType> value) {
        this.consumes = CollectionUtils.newList(value);
        return this;
    }

    public Swagger addConsumes(Collection<MediaType> values) {
        this.consumes = CollectionUtils.addToList(this.consumes, values);
        return this;
    }

    public Swagger consumes(Object ... values) {
        this.consumes = CollectionUtils.addToList(this.consumes, values, MediaType.class, new Type[0]);
        return this;
    }

    public List<MediaType> getProduces() {
        return this.produces;
    }

    public Swagger setProduces(Collection<MediaType> value) {
        this.produces = CollectionUtils.newList(value);
        return this;
    }

    public Swagger addProduces(Collection<MediaType> values) {
        this.produces = CollectionUtils.addToList(this.produces, values);
        return this;
    }

    public Swagger produces(Object ... values) {
        this.produces = CollectionUtils.addToList(this.produces, values, MediaType.class, new Type[0]);
        return this;
    }

    public Map<String, OperationMap> getPaths() {
        return this.paths;
    }

    public OperationMap getPath(String path) {
        return this.getPaths().get(path);
    }

    public Operation getOperation(String path, String operation) {
        OperationMap om = this.getPath(path);
        if (om == null) {
            return null;
        }
        return (Operation)om.get(operation);
    }

    public ResponseInfo getResponseInfo(String path, String operation, Object status) {
        OperationMap om = this.getPath(path);
        if (om == null) {
            return null;
        }
        Operation op = (Operation)om.get(operation);
        if (op == null) {
            return null;
        }
        return op.getResponse(status);
    }

    public Swagger setPaths(Map<String, OperationMap> value) {
        this.paths = CollectionUtils.newSortedMap(value, PATH_COMPARATOR);
        return this;
    }

    public Swagger addPaths(Map<String, OperationMap> values) {
        this.paths = CollectionUtils.addToSortedMap(this.paths, values, PATH_COMPARATOR);
        return this;
    }

    public Swagger path(String path, String methodName, Operation operation) {
        OperationMap p;
        if (this.paths == null) {
            this.paths = new TreeMap<String, OperationMap>(PATH_COMPARATOR);
        }
        if ((p = this.paths.get(path)) == null) {
            p = new OperationMap();
            this.paths.put(path, p);
        }
        p.put(methodName, operation);
        return this;
    }

    public Swagger paths(Object ... values) {
        if (this.paths == null) {
            this.paths = new TreeMap<String, OperationMap>(PATH_COMPARATOR);
        }
        this.paths = CollectionUtils.addToMap(this.paths, values, String.class, Map.class, new Type[]{String.class, Operation.class});
        return this;
    }

    public Map<String, ObjectMap> getDefinitions() {
        return this.definitions;
    }

    public Swagger setDefinitions(Map<String, ObjectMap> value) {
        this.definitions = CollectionUtils.newMap(value);
        return this;
    }

    public Swagger addDefinitions(Map<String, ObjectMap> values) {
        this.definitions = CollectionUtils.addToMap(this.definitions, values);
        return this;
    }

    public Swagger definition(String name, ObjectMap schema) {
        this.definitions = CollectionUtils.addToMap(this.definitions, name, schema);
        return this;
    }

    public Swagger definitions(Object ... values) {
        this.definitions = CollectionUtils.addToMap(this.definitions, values, String.class, ObjectMap.class, new Type[0]);
        return this;
    }

    public boolean hasDefinitions() {
        return this.definitions != null && !this.definitions.isEmpty();
    }

    public Map<String, ParameterInfo> getParameters() {
        return this.parameters;
    }

    public Swagger setParameters(Map<String, ParameterInfo> value) {
        this.parameters = CollectionUtils.newMap(value);
        return this;
    }

    public Swagger addParameters(Map<String, ParameterInfo> values) {
        this.parameters = CollectionUtils.addToMap(this.parameters, values);
        return this;
    }

    public Swagger parameter(String name, ParameterInfo parameter) {
        this.parameters = CollectionUtils.addToMap(this.parameters, name, parameter);
        return this;
    }

    public Swagger parameters(Object ... values) {
        this.parameters = CollectionUtils.addToMap(this.parameters, values, String.class, ParameterInfo.class, new Type[0]);
        return this;
    }

    public ParameterInfo getParameterInfo(String path, String method, String in, String name) {
        Operation o;
        OperationMap om = this.getPath(path);
        if (om != null && (o = (Operation)om.get(method)) != null) {
            return o.getParameter(in, name);
        }
        return null;
    }

    public Map<String, ResponseInfo> getResponses() {
        return this.responses;
    }

    public Swagger setResponses(Map<String, ResponseInfo> value) {
        this.responses = CollectionUtils.newMap(value);
        return this;
    }

    public Swagger addResponses(Map<String, ResponseInfo> values) {
        this.responses = CollectionUtils.addToMap(this.responses, values);
        return this;
    }

    public Swagger response(String name, ResponseInfo response) {
        this.responses = CollectionUtils.addToMap(this.responses, name, response);
        return this;
    }

    public Swagger responses(Object ... values) {
        this.responses = CollectionUtils.addToMap(this.responses, values, String.class, ResponseInfo.class, new Type[0]);
        return this;
    }

    public Map<String, SecurityScheme> getSecurityDefinitions() {
        return this.securityDefinitions;
    }

    public Swagger setSecurityDefinitions(Map<String, SecurityScheme> value) {
        this.securityDefinitions = CollectionUtils.newMap(value);
        return this;
    }

    public Swagger addSecurityDefinitions(Map<String, SecurityScheme> values) {
        this.securityDefinitions = CollectionUtils.addToMap(this.securityDefinitions, values);
        return this;
    }

    public Swagger securityDefinition(String name, SecurityScheme securityScheme) {
        this.securityDefinitions = CollectionUtils.addToMap(this.securityDefinitions, name, securityScheme);
        return this;
    }

    public Swagger securityDefinitions(Object ... values) {
        this.securityDefinitions = CollectionUtils.addToMap(this.securityDefinitions, values, String.class, SecurityScheme.class, new Type[0]);
        return this;
    }

    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    public Swagger setSecurity(Collection<Map<String, List<String>>> value) {
        this.security = CollectionUtils.newList(value);
        return this;
    }

    public Swagger addSecurity(Collection<Map<String, List<String>>> values) {
        this.security = CollectionUtils.addToList(this.security, values);
        return this;
    }

    public Swagger security(String scheme, String ... alternatives) {
        LinkedHashMap<String, List<String>> m = new LinkedHashMap<String, List<String>>();
        m.put(scheme, Arrays.asList(alternatives));
        return this.addSecurity(Collections.singleton(m));
    }

    public Swagger securities(Object ... values) {
        this.security = CollectionUtils.addToList(this.security, values, Map.class, new Type[]{String.class, List.class, String.class});
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Swagger setTags(Collection<Tag> value) {
        this.tags = CollectionUtils.newList(value);
        return this;
    }

    public Swagger addTags(Collection<Tag> values) {
        this.tags = CollectionUtils.addToList(this.tags, values);
        return this;
    }

    public Swagger tags(Object ... values) {
        this.tags = CollectionUtils.addToList(this.tags, values, Tag.class, new Type[0]);
        return this;
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public Swagger setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    public Swagger externalDocs(Object value) {
        return this.setExternalDocs(ObjectUtils.toType(value, ExternalDocumentation.class));
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "swagger": {
                return ObjectUtils.toType(this.getSwagger(), type);
            }
            case "info": {
                return ObjectUtils.toType(this.getInfo(), type);
            }
            case "host": {
                return ObjectUtils.toType(this.getHost(), type);
            }
            case "basePath": {
                return ObjectUtils.toType(this.getBasePath(), type);
            }
            case "schemes": {
                return ObjectUtils.toType(this.getSchemes(), type);
            }
            case "consumes": {
                return ObjectUtils.toType(this.getConsumes(), type);
            }
            case "produces": {
                return ObjectUtils.toType(this.getProduces(), type);
            }
            case "paths": {
                return ObjectUtils.toType(this.getPaths(), type);
            }
            case "definitions": {
                return ObjectUtils.toType(this.getDefinitions(), type);
            }
            case "parameters": {
                return ObjectUtils.toType(this.getParameters(), type);
            }
            case "responses": {
                return ObjectUtils.toType(this.getResponses(), type);
            }
            case "securityDefinitions": {
                return ObjectUtils.toType(this.getSecurityDefinitions(), type);
            }
            case "security": {
                return ObjectUtils.toType(this.getSecurity(), type);
            }
            case "tags": {
                return ObjectUtils.toType(this.getTags(), type);
            }
            case "externalDocs": {
                return ObjectUtils.toType(this.getExternalDocs(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Swagger set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "swagger": {
                return this.swagger(value);
            }
            case "info": {
                return this.info(value);
            }
            case "host": {
                return this.host(value);
            }
            case "basePath": {
                return this.basePath(value);
            }
            case "schemes": {
                return this.setSchemes(null).schemes(value);
            }
            case "consumes": {
                return this.setConsumes(null).consumes(value);
            }
            case "produces": {
                return this.setProduces(null).produces(value);
            }
            case "paths": {
                return this.setPaths(null).paths(value);
            }
            case "definitions": {
                return this.setDefinitions(null).definitions(value);
            }
            case "parameters": {
                return this.setParameters(null).parameters(value);
            }
            case "responses": {
                return this.setResponses(null).responses(value);
            }
            case "securityDefinitions": {
                return this.setSecurityDefinitions(null).securityDefinitions(value);
            }
            case "security": {
                return this.setSecurity(null).securities(value);
            }
            case "tags": {
                return this.setTags(null).tags(value);
            }
            case "externalDocs": {
                return this.externalDocs(value);
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        ASet<String> s = new ASet<String>().appendIf(this.swagger != null, "swagger").appendIf(this.info != null, "info").appendIf(this.host != null, "host").appendIf(this.basePath != null, "basePath").appendIf(this.schemes != null, "schemes").appendIf(this.consumes != null, "consumes").appendIf(this.produces != null, "produces").appendIf(this.paths != null, "paths").appendIf(this.definitions != null, "definitions").appendIf(this.parameters != null, "parameters").appendIf(this.responses != null, "responses").appendIf(this.securityDefinitions != null, "securityDefinitions").appendIf(this.security != null, "security").appendIf(this.tags != null, "tags").appendIf(this.externalDocs != null, "externalDocs");
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public String toString() {
        return JsonSerializer.DEFAULT.toString(this);
    }

    public <T> T findRef(String ref, Class<T> c) {
        if (StringUtils.isEmpty(ref)) {
            return null;
        }
        if (!ref.startsWith("#/")) {
            throw new RuntimeException("Unsupported reference:  '" + ref + '\"');
        }
        try {
            return new PojoRest(this).get(ref.substring(1), c);
        }
        catch (Exception e) {
            throw new BeanRuntimeException((Throwable)e, c, "Reference ''{0}'' could not be converted to type ''{1}''.", ref, c.getName());
        }
    }
}

