/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.nio.charset.Charset;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParser;

public abstract class ReaderParserSession
extends ParserSession {
    private final ReaderParser ctx;
    private final Charset fileCharset;
    private final Charset streamCharset;

    protected ReaderParserSession(ReaderParser ctx, ParserSessionArgs args) {
        super(ctx, args);
        this.ctx = ctx;
        this.fileCharset = this.getProperty("ReaderParser.fileCharset.s", Charset.class, ctx.getFileCharset());
        this.streamCharset = this.getProperty("ReaderParser.streamCharset.s", Charset.class, ctx.getStreamCharset());
    }

    protected ReaderParserSession(ParserSessionArgs args) {
        this(ReaderParser.DEFAULT, args);
    }

    @Override
    public final boolean isReaderParser() {
        return true;
    }

    @Override
    public final ParserPipe createPipe(Object input) {
        return this.setPipe(new ParserPipe(input, this.isDebug(), this.ctx.isStrict(), this.ctx.isAutoCloseStreams(), this.ctx.isUnbuffered(), this.streamCharset, this.fileCharset));
    }

    protected Charset getFileCharset() {
        return this.fileCharset;
    }

    protected Charset getStreamCharset() {
        return this.streamCharset;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append("ReaderParserSession", new DefaultFilteringObjectMap().append("fileCharset", this.fileCharset).append("streamCharset", this.streamCharset));
    }
}

