/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.Iterator;
import java.util.function.Function;

public class MappedIterable<I, E>
implements Iterable<E> {
    final Iterator<I> i;
    final Function<I, E> f;

    protected MappedIterable(Iterable<I> i, Function<I, E> f) {
        this.i = i.iterator();
        this.f = f;
    }

    public static <I, E> Iterable<E> of(Iterable<I> i, Function<I, E> f) {
        return new MappedIterable<I, E>(i, f);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return MappedIterable.this.i.hasNext();
            }

            @Override
            public E next() {
                return MappedIterable.this.f.apply(MappedIterable.this.i.next());
            }
        };
    }
}

