/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.sort.formats.common;

import org.apache.inlong.common.pojo.sort.dataflow.field.format.DecimalFormatInfo;
import org.apache.inlong.common.pojo.sort.dataflow.field.format.FormatInfo;

import org.junit.Test;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;

import static org.junit.Assert.assertEquals;

/**
 * Unit tests for {@link DecimalFormatInfo}.
 */
public class DecimalFormatInfoTest extends FormatInfoTestBase {

    @Override
    Collection<FormatInfo> createFormatInfos() {
        return Collections.singletonList(DecimalFormatInfo.INSTANCE);
    }

    @Test
    public void testSerialize() {
        assertEquals(
                "1111.0000000000000000000000001",
                DecimalFormatInfo.INSTANCE.serialize(
                        new BigDecimal("1111.0000000000000000000000001")));
    }

    @Test
    public void testDeserialize() {
        assertEquals(
                new BigDecimal("1111.0000000000000000000000001"),
                DecimalFormatInfo.INSTANCE.deserialize(
                        "1111.0000000000000000000000001"));
    }
}
