/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.sort.iceberg.source.reader;

import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.connector.base.source.reader.RecordEmitter;
import org.apache.iceberg.flink.source.reader.RecordAndPosition;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;

/**
 * Copy from iceberg-flink:iceberg-flink-1.15:1.3.1
 */
final class IcebergSourceRecordEmitter<T>
        implements
            RecordEmitter<RecordAndPosition<T>, T, IcebergSourceSplit> {

    IcebergSourceRecordEmitter() {
    }

    @Override
    public void emitRecord(
            RecordAndPosition<T> element, SourceOutput<T> output, IcebergSourceSplit split) {
        output.collect(element.record());
        split.updatePosition(element.fileOffset(), element.recordOffset());
    }
}
