/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.security.SaslStatus;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.handler.codec.ByteToMessageDecoder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SaslChallengeDecoder
extends ByteToMessageDecoder {
    private static final int MAX_CHALLENGE_SIZE = 0x100000;

    private ByteBuf tryDecodeChallenge(ByteBuf in, int offset, int readableBytes) throws IOException {
        if (readableBytes < 4) {
            return null;
        }
        int len = in.getInt(offset);
        if (len <= 0) {
            in.readerIndex(offset + 4);
            return in.retainedSlice(offset, 4);
        }
        if (len > 0x100000) {
            throw new IOException("Sasl challenge too large(" + len + "), max allowed is " + 0x100000);
        }
        int totalLen = 4 + len;
        if (readableBytes < totalLen) {
            return null;
        }
        in.readerIndex(offset + totalLen);
        return in.retainedSlice(offset, totalLen);
    }

    private void tryDecodeError(ByteBuf in, int offset, int readableBytes) throws IOException {
        if (readableBytes < 4) {
            return;
        }
        int classLen = in.getInt(offset);
        if (classLen <= 0) {
            throw new IOException("Invalid exception class name length " + classLen);
        }
        if (classLen > 0x100000) {
            throw new IOException("Exception class name length too large(" + classLen + "), max allowed is " + 0x100000);
        }
        if (readableBytes < 4 + classLen + 4) {
            return;
        }
        int msgLen = in.getInt(offset + 4 + classLen);
        if (msgLen <= 0) {
            throw new IOException("Invalid exception message length " + msgLen);
        }
        if (msgLen > 0x100000) {
            throw new IOException("Exception message length too large(" + msgLen + "), max allowed is " + 0x100000);
        }
        int totalLen = classLen + msgLen + 8;
        if (readableBytes < totalLen) {
            return;
        }
        String className = in.toString(offset + 4, classLen, HConstants.UTF8_CHARSET);
        String msg = in.toString(offset + classLen + 8, msgLen, HConstants.UTF8_CHARSET);
        in.readerIndex(offset + totalLen);
        throw new RemoteException(className, msg);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int readableBytes = in.readableBytes();
        if (readableBytes < 4) {
            return;
        }
        int offset = in.readerIndex();
        int status = in.getInt(offset);
        if (status == SaslStatus.SUCCESS.state) {
            ByteBuf challenge = this.tryDecodeChallenge(in, offset + 4, readableBytes - 4);
            if (challenge != null) {
                out.add(challenge);
            }
        } else {
            this.tryDecodeError(in, offset + 4, readableBytes - 4);
        }
    }
}

