/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shiro.util.AntPathMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathUtils.class);
    private static final AntPathMatcher MATCHER = new AntPathMatcher();

    public static boolean antPathMatch(String pathStr, String patternStr) {
        boolean result = MATCHER.match(patternStr, pathStr);
        LOGGER.info("path: {}, pattern: {}, result: {}", new Object[]{pathStr, patternStr, result});
        return result;
    }

    public static boolean antPathIncluded(String dirStr, String patternStr) {
        List dirArr = Stream.of(dirStr.split(File.separator)).collect(Collectors.toList());
        List patternDirArr = Stream.of(patternStr.split(File.separator)).collect(Collectors.toList());
        int everything = patternDirArr.indexOf("**");
        if (everything != -1) {
            return PathUtils.antPathMatch(String.join((CharSequence)File.separator, dirArr.subList(0, everything)), String.join((CharSequence)File.separator, patternDirArr.subList(0, everything)));
        }
        return PathUtils.antPathMatch(dirStr, String.join((CharSequence)File.separator, patternDirArr.subList(0, dirArr.size())));
    }

    public static String findRootPath(String patternStr) {
        Path parentPath;
        Path currentPath = Paths.get(patternStr, new String[0]);
        if (!Files.exists(currentPath, new LinkOption[0]) && (parentPath = currentPath.getParent()) != null) {
            return PathUtils.findRootPath(parentPath.toString());
        }
        if (Files.isDirectory(currentPath, new LinkOption[0])) {
            return patternStr;
        }
        return currentPath.getParent().toString();
    }

    public static Set<String> findCommonRootPath(Collection<String> patternStrs) {
        List rootDirs = patternStrs.stream().map(PathUtils::findRootPath).collect(Collectors.toSet()).stream().collect(Collectors.toList());
        HashSet<String> mergedRootDirs = new HashSet<String>();
        for (int i = 0; i < rootDirs.size(); ++i) {
            String minCommonWatchDir = (String)rootDirs.get(i);
            for (int j = i; j < rootDirs.size(); ++j) {
                if (!minCommonWatchDir.startsWith((String)rootDirs.get(j))) continue;
                minCommonWatchDir = (String)rootDirs.get(j);
            }
            mergedRootDirs.add(minCommonWatchDir);
        }
        return mergedRootDirs;
    }

    public static void main(String[] args) {
    }

    static {
        MATCHER.setPathSeparator(File.separator);
    }
}

