/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.hashtable;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentWritable;
import org.apache.flink.core.memory.SeekableDataInputView;
import org.apache.flink.runtime.io.disk.iomanager.AbstractChannelWriterOutputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.ChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.hashtable.BaseHybridHashTable;
import org.apache.flink.table.runtime.hashtable.LongHybridHashTable;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.util.FileChannelUtil;
import org.apache.flink.table.runtime.util.LazyMemorySegmentPool;
import org.apache.flink.table.runtime.util.RowIterator;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongHashPartition
extends AbstractPagedInputView
implements SeekableDataInputView {
    private static final Logger LOG = LoggerFactory.getLogger(LongHashPartition.class);
    private static final int SIZE_BITS = 28;
    private static final int SIZE_MASK = 0xFFFFFFF;
    private static final int SPARSE_BUCKET_ELEMENT_SIZE_IN_BYTES = 16;
    static final long INVALID_ADDRESS = 0xFFFFFFFFFL;
    private final LongHybridHashTable longTable;
    private final int segmentSize;
    private final int segmentSizeBits;
    private final int segmentSizeMask;
    private int partitionNum;
    private final BinaryRowDataSerializer buildSideSerializer;
    private final BinaryRowData buildReuseRow;
    private int recursionLevel;
    private long minKey = Long.MAX_VALUE;
    private long maxKey = Long.MIN_VALUE;
    private MemorySegment[] buckets;
    private int numBuckets;
    private int numBucketsMask;
    private MemorySegment[] partitionBuffers;
    private int finalBufferLimit;
    private int currentBufferNum;
    private BuildSideBuffer buildSideWriteBuffer;
    AbstractChannelWriterOutputView probeSideBuffer;
    long probeSideRecordCounter;
    private long numKeys;
    private final MatchIterator iterator;
    private BlockChannelWriter<MemorySegment> buildSideChannel;
    private long buildSideRecordCounter;
    int probeNumBytesInLastSeg;

    LongHashPartition(LongHybridHashTable longTable, int partitionNum, BinaryRowDataSerializer buildSideSerializer, double estimatedRowCount, int maxSegs, int recursionLevel) {
        this(longTable, partitionNum, buildSideSerializer, LongHashPartition.getBucketBuffersByRowCount((long)estimatedRowCount, maxSegs, longTable.pageSize()), recursionLevel, null, 0);
        this.buildSideWriteBuffer = new BuildSideBuffer(longTable.nextSegment());
    }

    LongHashPartition(LongHybridHashTable longTable, int partitionNum, BinaryRowDataSerializer buildSideSerializer, int bucketNumSegs, int recursionLevel, List<MemorySegment> buffers, int lastSegmentLimit) {
        this(longTable, buildSideSerializer, LongHashPartition.listToArray(buffers));
        this.partitionNum = partitionNum;
        this.recursionLevel = recursionLevel;
        int numBuckets = MathUtils.roundDownToPowerOf2((int)(this.segmentSize / 16 * bucketNumSegs));
        MemorySegment[] buckets = new MemorySegment[bucketNumSegs];
        for (int i = 0; i < bucketNumSegs; ++i) {
            buckets[i] = longTable.nextSegment();
        }
        this.setNewBuckets(buckets, numBuckets);
        this.finalBufferLimit = lastSegmentLimit;
    }

    LongHashPartition(LongHybridHashTable longTable, BinaryRowDataSerializer buildSideSerializer, MemorySegment[] partitionBuffers) {
        super(0);
        this.longTable = longTable;
        this.buildSideSerializer = buildSideSerializer;
        this.buildReuseRow = buildSideSerializer.createInstance();
        this.segmentSize = longTable.pageSize();
        Preconditions.checkArgument((this.segmentSize % 16 == 0 ? 1 : 0) != 0);
        this.partitionBuffers = partitionBuffers;
        this.segmentSizeBits = MathUtils.log2strict((int)this.segmentSize);
        this.segmentSizeMask = this.segmentSize - 1;
        this.finalBufferLimit = this.segmentSize;
        this.iterator = new MatchIterator();
    }

    private static MemorySegment[] listToArray(List<MemorySegment> list) {
        if (list != null) {
            return list.toArray(new MemorySegment[0]);
        }
        return null;
    }

    private static int getBucketBuffersByRowCount(long rowCount, int maxSegs, int segmentSize) {
        int minNumBuckets = (int)Math.ceil((double)rowCount / 0.5);
        Preconditions.checkArgument((segmentSize % 16 == 0 ? 1 : 0) != 0);
        return MathUtils.roundDownToPowerOf2((int)((int)Math.max(1.0, Math.min((double)maxSegs, Math.ceil((double)minNumBuckets * 16.0 / (double)segmentSize)))));
    }

    private void setNewBuckets(MemorySegment[] buckets, int numBuckets) {
        for (MemorySegment segment : buckets) {
            for (int i = 0; i < this.segmentSize; i += 16) {
                segment.putLong(i, 0L);
                segment.putLong(i + 8, 0xFFFFFFFFFL);
            }
        }
        this.buckets = buckets;
        Preconditions.checkArgument((boolean)MathUtils.isPowerOf2((long)numBuckets));
        this.numBuckets = numBuckets;
        this.numBucketsMask = numBuckets - 1;
        this.numKeys = 0L;
    }

    private static long toAddrAndLen(long address, int size) {
        return address << 28 | (long)size;
    }

    private static long toAddress(long addrAndLen) {
        return addrAndLen >>> 28;
    }

    private static int toLength(long addrAndLen) {
        return (int)(addrAndLen & 0xFFFFFFFL);
    }

    MatchIterator valueIter(long address) {
        this.iterator.set(address);
        return this.iterator;
    }

    public MatchIterator get(long key, int hashCode) {
        long address;
        int bucket = this.findBucket(hashCode);
        int bucketOffset = bucket << 4;
        MemorySegment segment = this.buckets[bucketOffset >>> this.segmentSizeBits];
        int segOffset = bucketOffset & this.segmentSizeMask;
        while ((address = segment.getLong(segOffset + 8)) != 0xFFFFFFFFFL) {
            if (segment.getLong(segOffset) == key) {
                return this.valueIter(address);
            }
            bucket = bucket + 1 & this.numBucketsMask;
            if (segOffset + 16 < this.segmentSize) {
                segOffset += 16;
                continue;
            }
            bucketOffset = bucket << 4;
            segOffset = bucketOffset & this.segmentSizeMask;
            segment = this.buckets[bucketOffset >>> this.segmentSizeBits];
        }
        return this.valueIter(0xFFFFFFFFFL);
    }

    private void updateIndex(long key, int hashCode, long address, int size, MemorySegment dataSegment, int currentPositionInSegment) throws IOException {
        long currAddress;
        assert (this.numKeys <= (long)(this.numBuckets / 2));
        int bucketId = this.findBucket(hashCode);
        int bucketOffset = bucketId * 16;
        MemorySegment segment = this.buckets[bucketOffset >>> this.segmentSizeBits];
        int segOffset = bucketOffset & this.segmentSizeMask;
        while (true) {
            currAddress = segment.getLong(segOffset + 8);
            if (segment.getLong(segOffset) == key || currAddress == 0xFFFFFFFFFL) break;
            bucketId = bucketId + 1 & this.numBucketsMask;
            if (segOffset + 16 < this.segmentSize) {
                segOffset += 16;
                continue;
            }
            bucketOffset = bucketId * 16;
            segment = this.buckets[bucketOffset >>> this.segmentSizeBits];
            segOffset = bucketOffset & this.segmentSizeMask;
        }
        if (currAddress == 0xFFFFFFFFFL) {
            segment.putLong(segOffset, key);
            segment.putLong(segOffset + 8, address);
            ++this.numKeys;
            if (dataSegment != null) {
                dataSegment.putLong(currentPositionInSegment, LongHashPartition.toAddrAndLen(0xFFFFFFFFFL, size));
            }
            if (this.numKeys * 2L > (long)this.numBuckets) {
                this.resize();
            }
        } else {
            dataSegment.putLong(currentPositionInSegment, LongHashPartition.toAddrAndLen(currAddress, size));
            segment.putLong(segOffset + 8, address);
        }
    }

    private int findBucket(int hash) {
        return BaseHybridHashTable.partitionLevelHash(hash) & this.numBucketsMask;
    }

    private void resize() throws IOException {
        MemorySegment[] oldBuckets = this.buckets;
        int oldNumBuckets = this.numBuckets;
        int newNumSegs = oldBuckets.length * 2;
        int newNumBuckets = MathUtils.roundDownToPowerOf2((int)(newNumSegs * this.segmentSize / 16));
        MemorySegment[] newBuckets = new MemorySegment[newNumSegs];
        for (int i = 0; i < newNumSegs; ++i) {
            MemorySegment seg = this.longTable.getNextBuffer();
            if (seg == null) {
                int spilledPart = this.longTable.spillPartition();
                if (spilledPart == this.partitionNum) {
                    this.longTable.returnAll(Arrays.asList(newBuckets));
                    return;
                }
                seg = this.longTable.getNextBuffer();
                if (seg == null) {
                    throw new RuntimeException("Bug in HybridHashJoin: No memory became available after spilling a partition.");
                }
            }
            newBuckets[i] = seg;
        }
        this.setNewBuckets(newBuckets, newNumBuckets);
        this.reHash(oldBuckets, oldNumBuckets);
    }

    private void reHash(MemorySegment[] oldBuckets, int oldNumBuckets) throws IOException {
        long reHashStartTime = System.currentTimeMillis();
        int bucketOffset = 0;
        MemorySegment segment = oldBuckets[bucketOffset];
        int segOffset = 0;
        for (int i = 0; i < oldNumBuckets; ++i) {
            long address = segment.getLong(segOffset + 8);
            if (address != 0xFFFFFFFFFL) {
                long key = segment.getLong(segOffset);
                this.updateIndex(key, LongHybridHashTable.hashLong(key, this.recursionLevel), address, 0, null, 0);
            }
            if (i == oldNumBuckets - 1) continue;
            if (segOffset + 16 < this.segmentSize) {
                segOffset += 16;
                continue;
            }
            segment = oldBuckets[++bucketOffset];
            segOffset = 0;
        }
        this.longTable.returnAll(Arrays.asList(oldBuckets));
        LOG.info("The rehash take {} ms for {} segments", (Object)(System.currentTimeMillis() - reHashStartTime), (Object)this.numBuckets);
    }

    public MemorySegment[] getBuckets() {
        return this.buckets;
    }

    int getBuildSideBlockCount() {
        return this.partitionBuffers == null ? this.buildSideWriteBuffer.getBlockCount() : this.partitionBuffers.length;
    }

    int getProbeSideBlockCount() {
        return this.probeSideBuffer == null ? -1 : this.probeSideBuffer.getBlockCount();
    }

    BlockChannelWriter<MemorySegment> getBuildSideChannel() {
        return this.buildSideChannel;
    }

    int getPartitionNumber() {
        return this.partitionNum;
    }

    MemorySegment[] getPartitionBuffers() {
        return this.partitionBuffers;
    }

    int getRecursionLevel() {
        return this.recursionLevel;
    }

    int getNumOccupiedMemorySegments() {
        int numPartitionBuffers = this.partitionBuffers != null ? this.partitionBuffers.length : this.buildSideWriteBuffer.getNumOccupiedMemorySegments();
        return numPartitionBuffers + this.buckets.length;
    }

    int spillPartition(IOManager ioAccess, FileIOChannel.ID targetChannel, LinkedBlockingQueue<MemorySegment> bufferReturnQueue) throws IOException {
        if (!this.isInMemory()) {
            throw new RuntimeException("Bug in Hybrid Hash Join: Request to spill a partition that has already been spilled.");
        }
        if (this.getNumOccupiedMemorySegments() < 2) {
            throw new RuntimeException("Bug in Hybrid Hash Join: Request to spill a partition with less than two buffers.");
        }
        this.buildSideChannel = FileChannelUtil.createBlockChannelWriter(ioAccess, targetChannel, bufferReturnQueue, this.longTable.compressionEnable(), this.longTable.compressionCodecFactory(), this.longTable.compressionBlockSize(), this.segmentSize);
        return this.buildSideWriteBuffer.spill(this.buildSideChannel);
    }

    int finalizeBuildPhase(IOManager ioAccess, FileIOChannel.Enumerator probeChannelEnumerator) throws IOException {
        this.finalBufferLimit = this.buildSideWriteBuffer.getCurrentPositionInSegment();
        this.partitionBuffers = this.buildSideWriteBuffer.close();
        if (!this.isInMemory()) {
            this.buildSideChannel.close();
            this.probeSideBuffer = FileChannelUtil.createOutputView(ioAccess, probeChannelEnumerator.next(), this.longTable.compressionEnable(), this.longTable.compressionCodecFactory(), this.longTable.compressionBlockSize(), this.segmentSize);
            return 1;
        }
        return 0;
    }

    void finalizeProbePhase(List<LongHashPartition> spilledPartitions) throws IOException {
        if (this.isInMemory()) {
            this.releaseBuckets();
            this.longTable.returnAll(Arrays.asList(this.partitionBuffers));
            this.partitionBuffers = null;
        } else if (this.probeSideRecordCounter == 0L) {
            this.probeSideBuffer.close();
            this.buildSideChannel.deleteChannel();
            this.probeSideBuffer.getChannel().deleteChannel();
        } else {
            this.probeNumBytesInLastSeg = this.probeSideBuffer.close();
            spilledPartitions.add(this);
        }
    }

    final PartitionIterator newPartitionIterator() {
        return new PartitionIterator();
    }

    final int getLastSegmentLimit() {
        return this.finalBufferLimit;
    }

    public void setReadPosition(long pointer) {
        int bufferNum = (int)(pointer >>> this.segmentSizeBits);
        int offset = (int)(pointer & (long)this.segmentSizeMask);
        this.currentBufferNum = bufferNum;
        this.seekInput(this.partitionBuffers[bufferNum], offset, bufferNum < this.partitionBuffers.length - 1 ? this.segmentSize : this.finalBufferLimit);
    }

    protected MemorySegment nextSegment(MemorySegment current) throws IOException {
        ++this.currentBufferNum;
        if (this.currentBufferNum < this.partitionBuffers.length) {
            return this.partitionBuffers[this.currentBufferNum];
        }
        throw new EOFException();
    }

    protected int getLimitForSegment(MemorySegment segment) {
        return segment == this.partitionBuffers[this.partitionBuffers.length - 1] ? this.finalBufferLimit : this.segmentSize;
    }

    boolean isInMemory() {
        return this.buildSideChannel == null;
    }

    final void insertIntoProbeBuffer(BinaryRowDataSerializer probeSer, BinaryRowData record) throws IOException {
        probeSer.serialize(record, (DataOutputView)this.probeSideBuffer);
        ++this.probeSideRecordCounter;
    }

    long getBuildSideRecordCount() {
        return this.buildSideRecordCounter;
    }

    long getMinKey() {
        return this.minKey;
    }

    long getMaxKey() {
        return this.maxKey;
    }

    private void updateMinMax(long key) {
        if (key < this.minKey) {
            this.minKey = key;
        }
        if (key > this.maxKey) {
            this.maxKey = key;
        }
    }

    void insertIntoBucket(long key, int hashCode, int size, long address) throws IOException {
        ++this.buildSideRecordCounter;
        this.updateMinMax(key);
        int bufferNum = (int)(address >>> this.segmentSizeBits);
        int offset = (int)(address & (long)(this.segmentSize - 1));
        this.updateIndex(key, hashCode, address, size, this.partitionBuffers[bufferNum], offset);
    }

    void insertIntoTable(long key, int hashCode, BinaryRowData row) throws IOException {
        ++this.buildSideRecordCounter;
        this.updateMinMax(key);
        int sizeInBytes = row.getSizeInBytes();
        if (sizeInBytes >= 0x10000000) {
            throw new UnsupportedOperationException("Does not support row that is larger than 256M");
        }
        if (this.isInMemory()) {
            this.checkWriteAdvance();
            if (this.isInMemory()) {
                this.updateIndex(key, hashCode, this.buildSideWriteBuffer.getCurrentPointer(), sizeInBytes, this.buildSideWriteBuffer.getCurrentSegment(), this.buildSideWriteBuffer.getCurrentPositionInSegment());
            } else {
                this.buildSideWriteBuffer.getCurrentSegment().putLong(this.buildSideWriteBuffer.getCurrentPositionInSegment(), LongHashPartition.toAddrAndLen(0xFFFFFFFFFL, sizeInBytes));
            }
            this.buildSideWriteBuffer.skipBytesToWrite(8);
            if (row.getSegments().length == 1) {
                this.buildSideWriteBuffer.write(row.getSegments()[0], row.getOffset(), sizeInBytes);
            } else {
                BinaryRowDataSerializer.serializeWithoutLengthSlow(row, (MemorySegmentWritable)this.buildSideWriteBuffer);
            }
        } else {
            this.serializeToPages(row);
        }
    }

    public void serializeToPages(BinaryRowData row) throws IOException {
        int sizeInBytes = row.getSizeInBytes();
        this.checkWriteAdvance();
        this.buildSideWriteBuffer.getCurrentSegment().putLong(this.buildSideWriteBuffer.getCurrentPositionInSegment(), LongHashPartition.toAddrAndLen(0xFFFFFFFFFL, row.getSizeInBytes()));
        this.buildSideWriteBuffer.skipBytesToWrite(8);
        if (row.getSegments().length == 1) {
            this.buildSideWriteBuffer.write(row.getSegments()[0], row.getOffset(), sizeInBytes);
        } else {
            BinaryRowDataSerializer.serializeWithoutLengthSlow(row, (MemorySegmentWritable)this.buildSideWriteBuffer);
        }
    }

    void releaseBuckets() {
        if (this.buckets != null) {
            this.longTable.returnAll(Arrays.asList(this.buckets));
            this.buckets = null;
        }
    }

    void clearAllMemory(LazyMemorySegmentPool pool) {
        if (this.buildSideWriteBuffer != null) {
            if (this.buildSideWriteBuffer.getCurrentSegment() != null) {
                pool.returnPage(this.buildSideWriteBuffer.getCurrentSegment());
            }
            pool.returnAll(this.buildSideWriteBuffer.targetList);
            this.buildSideWriteBuffer.targetList.clear();
            this.buildSideWriteBuffer = null;
        }
        this.releaseBuckets();
        if (this.partitionBuffers != null) {
            pool.returnAll(Arrays.asList(this.partitionBuffers));
            this.partitionBuffers = null;
        }
        try {
            if (this.buildSideChannel != null) {
                this.buildSideChannel.close();
                this.buildSideChannel.deleteChannel();
            }
            if (this.probeSideBuffer != null) {
                this.probeSideBuffer.getChannel().closeAndDelete();
                this.probeSideBuffer = null;
            }
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error deleting the partition files. Some temporary files might not be removed.", ioex);
        }
    }

    private void checkWriteAdvance() throws IOException {
        if (LongHashPartition.shouldAdvance(this.buildSideWriteBuffer.getSegmentSize() - this.buildSideWriteBuffer.getCurrentPositionInSegment(), this.buildSideSerializer)) {
            this.buildSideWriteBuffer.advance();
        }
    }

    private void checkReadAdvance() throws IOException {
        if (LongHashPartition.shouldAdvance(this.getCurrentSegmentLimit() - this.getCurrentPositionInSegment(), this.buildSideSerializer)) {
            this.advance();
        }
    }

    private static boolean shouldAdvance(int available, BinaryRowDataSerializer serializer) {
        return available < 8 + serializer.getFixedLengthPartSize();
    }

    static void deserializeFromPages(BinaryRowData reuse, ChannelReaderInputView inView, BinaryRowDataSerializer buildSideSerializer) throws IOException {
        if (LongHashPartition.shouldAdvance(inView.getCurrentSegmentLimit() - inView.getCurrentPositionInSegment(), buildSideSerializer)) {
            inView.advance();
        }
        MemorySegment segment = reuse.getSegments() != null ? reuse.getSegments()[0] : null;
        int length = LongHashPartition.toLength(inView.getCurrentSegment().getLong(inView.getCurrentPositionInSegment()));
        inView.skipBytesToRead(8);
        if (segment == null || segment.size() < length) {
            segment = MemorySegmentFactory.wrap((byte[])new byte[length]);
        }
        inView.readFully(segment.getHeapMemory(), 0, length);
        reuse.pointTo(segment, 0, length);
    }

    void iteratorToDenseBucket(MemorySegment[] denseBuckets, long addressOffset, long globalMinKey) {
        int bucketOffset = 0;
        MemorySegment segment = this.buckets[bucketOffset];
        int segOffset = 0;
        for (int i = 0; i < this.numBuckets; ++i) {
            long address = segment.getLong(segOffset + 8);
            if (address != 0xFFFFFFFFFL) {
                long key = segment.getLong(segOffset);
                long denseBucket = key - globalMinKey;
                long denseBucketOffset = denseBucket << 3;
                int denseSegIndex = (int)(denseBucketOffset >>> this.segmentSizeBits);
                int denseSegOffset = (int)(denseBucketOffset & (long)this.segmentSizeMask);
                denseBuckets[denseSegIndex].putLong(denseSegOffset, address + addressOffset);
            }
            if (i == this.numBuckets - 1) continue;
            if (segOffset + 16 < this.segmentSize) {
                segOffset += 16;
                continue;
            }
            segment = this.buckets[++bucketOffset];
            segOffset = 0;
        }
    }

    void updateDenseAddressOffset(long addressOffset) {
        if (addressOffset != 0L) {
            this.setReadPosition(0L);
            try {
                while (true) {
                    this.checkReadAdvance();
                    long addrAndLen = this.getCurrentSegment().getLong(this.getCurrentPositionInSegment());
                    long address = LongHashPartition.toAddress(addrAndLen);
                    int len = LongHashPartition.toLength(addrAndLen);
                    if (address != 0xFFFFFFFFFL) {
                        this.getCurrentSegment().putLong(this.getCurrentPositionInSegment(), LongHashPartition.toAddrAndLen(address + addressOffset, len));
                    }
                    this.skipBytesToRead(8 + len);
                }
            }
            catch (EOFException e) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    final class PartitionIterator
    implements RowIterator<BinaryRowData> {
        private long currentPointer;
        private BinaryRowData reuse;

        private PartitionIterator() {
            this.reuse = LongHashPartition.this.buildSideSerializer.createInstance();
            LongHashPartition.this.setReadPosition(0L);
        }

        @Override
        public boolean advanceNext() {
            try {
                LongHashPartition.this.checkReadAdvance();
                int pos = LongHashPartition.this.getCurrentPositionInSegment();
                this.currentPointer = ((long)LongHashPartition.this.currentBufferNum << LongHashPartition.this.segmentSizeBits) + (long)pos;
                long addrAndLen = LongHashPartition.this.getCurrentSegment().getLong(pos);
                LongHashPartition.this.skipBytesToRead(8);
                LongHashPartition.this.buildSideSerializer.pointTo(LongHashPartition.toLength(addrAndLen), this.reuse, LongHashPartition.this);
                return true;
            }
            catch (EOFException e) {
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        final long getPointer() {
            return this.currentPointer;
        }

        @Override
        public BinaryRowData getRow() {
            return this.reuse;
        }
    }

    public class MatchIterator
    implements RowIterator<BinaryRowData> {
        private long address;

        public void set(long address) {
            this.address = address;
        }

        @Override
        public boolean advanceNext() {
            if (this.address != 0xFFFFFFFFFL) {
                LongHashPartition.this.setReadPosition(this.address);
                long addrAndLen = LongHashPartition.this.getCurrentSegment().getLong(LongHashPartition.this.getCurrentPositionInSegment());
                this.address = LongHashPartition.toAddress(addrAndLen);
                int size = LongHashPartition.toLength(addrAndLen);
                try {
                    LongHashPartition.this.skipBytesToRead(8);
                    LongHashPartition.this.buildSideSerializer.pointTo(size, LongHashPartition.this.buildReuseRow, LongHashPartition.this);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }
            return false;
        }

        @Override
        public BinaryRowData getRow() {
            return LongHashPartition.this.buildReuseRow;
        }
    }

    private class BuildSideBuffer
    extends AbstractPagedOutputView {
        private final ArrayList<MemorySegment> targetList;
        private int currentBlockNumber;
        private BlockChannelWriter<MemorySegment> writer;

        private BuildSideBuffer(MemorySegment segment) {
            super(segment, segment.size(), 0);
            this.targetList = new ArrayList();
        }

        protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws IOException {
            MemorySegment next;
            if (this.writer == null) {
                this.targetList.add(current);
                next = LongHashPartition.this.longTable.nextSegment();
            } else {
                this.writer.writeBlock((Object)current);
                try {
                    next = (MemorySegment)this.writer.getReturnQueue().take();
                }
                catch (InterruptedException iex) {
                    throw new IOException("Hash Join Partition was interrupted while grabbing a new write-behind buffer.");
                }
            }
            ++this.currentBlockNumber;
            return next;
        }

        long getCurrentPointer() {
            return ((long)this.currentBlockNumber << LongHashPartition.this.segmentSizeBits) + (long)this.getCurrentPositionInSegment();
        }

        int getBlockCount() {
            return this.currentBlockNumber + 1;
        }

        int getNumOccupiedMemorySegments() {
            return this.targetList.size() + 1;
        }

        int spill(BlockChannelWriter<MemorySegment> writer) throws IOException {
            this.writer = writer;
            int numSegments = this.targetList.size();
            for (MemorySegment segment : this.targetList) {
                this.writer.writeBlock((Object)segment);
            }
            this.targetList.clear();
            return numSegments;
        }

        MemorySegment[] close() throws IOException {
            MemorySegment current = this.getCurrentSegment();
            if (current == null) {
                throw new IllegalStateException("Illegal State in LongHashTable: No current buffer when finalizing build side.");
            }
            this.clear();
            if (this.writer == null) {
                this.targetList.add(current);
                MemorySegment[] buffers = this.targetList.toArray(new MemorySegment[0]);
                this.targetList.clear();
                return buffers;
            }
            this.writer.writeBlock((Object)current);
            return null;
        }
    }
}

