/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.planner.expressions.RexNodeExpression;

@Internal
final class ResolvedExpressionJsonSerializer
extends StdSerializer<ResolvedExpression> {
    static final String TYPE = "type";
    static final String TYPE_REX_NODE_EXPRESSION = "rexNodeExpression";
    static final String REX_NODE = "rexNode";
    static final String SERIALIZABLE_STRING = "serializableString";

    ResolvedExpressionJsonSerializer() {
        super(ResolvedExpression.class);
    }

    public void serialize(ResolvedExpression resolvedExpression, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        if (!(resolvedExpression instanceof RexNodeExpression)) {
            throw new ValidationException(String.format("Expression '%s' cannot be serialized. Currently, only SQL expressions can be serialized in the persisted plan.", resolvedExpression.asSummaryString()));
        }
        this.serialize((RexNodeExpression)resolvedExpression, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndObject();
    }

    private void serialize(RexNodeExpression expression, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        serializerProvider.defaultSerializeField(REX_NODE, (Object)expression.getRexNode(), jsonGenerator);
        jsonGenerator.writeStringField(SERIALIZABLE_STRING, expression.asSerializableString());
    }
}

