/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.util.List;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractNullAwareCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastCodeBlock;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleProvider;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CharVarCharTrimPadCastRule;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

class RowToStringCastRule
extends AbstractNullAwareCodeGeneratorCastRule<ArrayData, String> {
    static final RowToStringCastRule INSTANCE = new RowToStringCastRule();

    private RowToStringCastRule() {
        super(CastRulePredicate.builder().predicate(RowToStringCastRule::matches).build());
    }

    private static boolean matches(LogicalType input, LogicalType target) {
        return (input.is(LogicalTypeRoot.ROW) || input.is(LogicalTypeRoot.STRUCTURED_TYPE)) && target.is(LogicalTypeFamily.CHARACTER_STRING) && LogicalTypeChecks.getFieldTypes((LogicalType)input).stream().allMatch(fieldType -> CastRuleProvider.exists(fieldType, target));
    }

    @Override
    protected String generateCodeBlockInternal(CodeGeneratorCastRule.Context context, String inputTerm, String returnVariable, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        List fields = LogicalTypeChecks.getFieldTypes((LogicalType)inputLogicalType);
        String builderTerm = CodeGenUtils.newName("builder");
        context.declareClassField(CodeGenUtils.className(StringBuilder.class), builderTerm, CastRuleUtils.constructorCall(StringBuilder.class, new Object[0]));
        String resultStringTerm = CodeGenUtils.newName("resultString");
        int length = LogicalTypeChecks.getLength((LogicalType)targetLogicalType);
        VarCharType targetTypeForElementCast = targetLogicalType.is(LogicalTypeFamily.CHARACTER_STRING) ? VarCharType.STRING_TYPE : targetLogicalType;
        CastRuleUtils.CodeWriter writer = new CastRuleUtils.CodeWriter().stmt(CastRuleUtils.methodCall(builderTerm, "setLength", 0)).stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.strLiteral("(")));
        for (int i = 0; i < fields.size(); ++i) {
            int fieldIndex = i;
            LogicalType fieldType = (LogicalType)fields.get(fieldIndex);
            String fieldTerm = CodeGenUtils.newName("f" + fieldIndex + "Value");
            String fieldIsNullTerm = CodeGenUtils.newName("f" + fieldIndex + "IsNull");
            CastCodeBlock codeBlock = CastRuleProvider.generateAlwaysNonNullCodeBlock(context, fieldTerm, fieldType, (LogicalType)targetTypeForElementCast);
            if (fieldIndex != 0) {
                String comma = RowToStringCastRule.getDelimiter(context);
                writer.stmt(CastRuleUtils.methodCall(builderTerm, "append", comma));
            }
            writer.declPrimitiveStmt(fieldType, fieldTerm).declStmt(Boolean.TYPE, fieldIsNullTerm, CastRuleUtils.methodCall(inputTerm, "isNullAt", fieldIndex)).ifStmt("!" + fieldIsNullTerm, thenBodyWriter -> thenBodyWriter.assignStmt(fieldTerm, CodeGenUtils.rowFieldReadAccess(fieldIndex, inputTerm, fieldType)).append(codeBlock).stmt(CastRuleUtils.methodCall(builderTerm, "append", codeBlock.getReturnTerm())), elseBodyWriter -> elseBodyWriter.stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.nullLiteral(context.legacyBehaviour()))));
        }
        writer.stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.strLiteral(")")));
        return CharVarCharTrimPadCastRule.padAndTrimStringIfNeeded(writer, targetLogicalType, context.legacyBehaviour(), length, resultStringTerm, builderTerm).assignStmt(returnVariable, CastRuleUtils.staticCall(BuiltInMethods.BINARY_STRING_DATA_FROM_STRING(), resultStringTerm)).toString();
    }

    private static String getDelimiter(CodeGeneratorCastRule.Context context) {
        String comma = context.legacyBehaviour() ? CastRuleUtils.strLiteral(",") : CastRuleUtils.strLiteral(", ");
        return comma;
    }
}

