/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.utils;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.document.DocumentReader;
import io.debezium.document.DocumentWriter;
import io.debezium.relational.history.AbstractDatabaseHistory;
import io.debezium.relational.history.DatabaseHistoryException;
import io.debezium.relational.history.DatabaseHistoryListener;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.util.Collect;
import io.debezium.util.FunctionalReadWriteLock;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.inlong.agent.plugin.message.SchemaRecord;
import org.apache.inlong.agent.plugin.utils.DatabaseHistoryUtil;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;

public class InLongDatabaseHistory
extends AbstractDatabaseHistory {
    public static final String DATABASE_HISTORY_INSTANCE_NAME = "database.history.instance.name";
    public static final Field FILE_PATH = Field.create((String)"database.history.file.filename").withDescription("The path to the file that will be used to record the database history").required();
    private static final Charset UTF8;
    public static Collection<Field> ALL_FIELDS;
    private final FunctionalReadWriteLock lock = FunctionalReadWriteLock.reentrant();
    private final DocumentWriter writer = DocumentWriter.defaultWriter();
    private final DocumentReader reader = DocumentReader.defaultReader();
    private final AtomicBoolean running = new AtomicBoolean();
    private ConcurrentLinkedQueue<SchemaRecord> schemaRecords;
    private String instanceName;
    private Path path;

    public static boolean isCompatible(Collection<SchemaRecord> records) {
        SchemaRecord record;
        Iterator<SchemaRecord> var1 = records.iterator();
        return !var1.hasNext() || (record = var1.next()).isHistoryRecord();
    }

    private ConcurrentLinkedQueue<SchemaRecord> getRegisteredHistoryRecord(String instanceName) {
        Collection<SchemaRecord> historyRecords = DatabaseHistoryUtil.retrieveHistory(instanceName);
        return new ConcurrentLinkedQueue<SchemaRecord>(historyRecords);
    }

    public void configure(Configuration config, HistoryRecordComparator comparator, DatabaseHistoryListener listener, boolean useCatalogBeforeSchema) {
        Collection<Field> var10001 = ALL_FIELDS;
        Logger var10002 = this.logger;
        Objects.requireNonNull(var10002);
        if (!config.validateAndRecord(var10001, arg_0 -> ((Logger)var10002).error(arg_0))) {
            throw new ConnectException("Error configuring an instance of " + ((Object)((Object)this)).getClass().getSimpleName() + "; check the logs for details");
        }
        if (this.running.get()) {
            throw new IllegalStateException("Database history file already initialized to " + this.path);
        }
        super.configure(config, comparator, listener, useCatalogBeforeSchema);
        this.instanceName = config.getString(DATABASE_HISTORY_INSTANCE_NAME);
        this.schemaRecords = this.getRegisteredHistoryRecord(this.instanceName);
        DatabaseHistoryUtil.registerHistory(this.instanceName, this.schemaRecords);
        this.path = Paths.get(config.getString(FILE_PATH), new String[0]);
    }

    public void start() {
        super.start();
        this.lock.write(() -> {
            if (this.running.compareAndSet(false, true)) {
                Path path = this.path;
                if (path == null) {
                    throw new IllegalStateException("FileDatabaseHistory must be configured before it is started");
                }
                try {
                    if (!this.storageExists()) {
                        if (path.getParent() != null && !Files.exists(path.getParent(), new LinkOption[0])) {
                            Files.createDirectories(path.getParent(), new FileAttribute[0]);
                        }
                        try {
                            Files.createFile(path, new FileAttribute[0]);
                        }
                        catch (FileAlreadyExistsException fileAlreadyExistsException) {}
                    }
                }
                catch (IOException var4) {
                    throw new DatabaseHistoryException("Unable to create history file at " + path + ": " + var4.getMessage(), (Throwable)var4);
                }
            }
        });
    }

    public void stop() {
        this.running.set(false);
        super.stop();
        DatabaseHistoryUtil.removeHistory(this.instanceName);
    }

    protected void storeRecord(HistoryRecord record) throws DatabaseHistoryException {
        if (record != null) {
            this.lock.write(() -> {
                block13: {
                    if (!this.running.get()) {
                        throw new IllegalStateException("The history has been stopped and will not accept more records");
                    }
                    try {
                        String line = this.writer.write(record.document());
                        try {
                            try (BufferedWriter historyWriter = Files.newBufferedWriter(this.path, StandardOpenOption.APPEND);){
                                try {
                                    historyWriter.append(line);
                                    historyWriter.newLine();
                                    this.schemaRecords.add(new SchemaRecord(record));
                                    break block13;
                                }
                                catch (IOException var7) {
                                    this.logger.error("Failed to add record to history at {}: {}", new Object[]{this.path, record, var7});
                                }
                            }
                            return;
                        }
                        catch (IOException var9) {
                            throw new DatabaseHistoryException("Unable to create writer for history file " + this.path + ": " + var9.getMessage(), (Throwable)var9);
                        }
                    }
                    catch (IOException var10) {
                        this.logger.error("Failed to convert record to string: {}", (Object)record, (Object)var10);
                    }
                }
            });
        }
    }

    protected synchronized void recoverRecords(Consumer<HistoryRecord> records) {
        this.lock.write(() -> {
            try {
                if (this.exists()) {
                    for (String line : Files.readAllLines(this.path, UTF8)) {
                        if (line == null || line.isEmpty()) continue;
                        records.accept(new HistoryRecord(this.reader.read(line)));
                    }
                }
            }
            catch (IOException var4) {
                this.logger.error("Failed to add recover records from history at {}", (Object)this.path, (Object)var4);
            }
        });
        this.schemaRecords.stream().map(SchemaRecord::getHistoryRecord).forEach(records);
    }

    public boolean exists() {
        return !this.schemaRecords.isEmpty();
    }

    public boolean storageExists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public String toString() {
        return "file " + (this.path != null ? this.path : "(unstarted)");
    }

    static {
        ALL_FIELDS = Collect.arrayListOf((Object)FILE_PATH, (Object[])new Field[0]);
        UTF8 = StandardCharsets.UTF_8;
    }
}

