/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.controller.group;

import com.google.gson.Gson;
import java.util.Map;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.controller.group.request.AddBlackGroupReq;
import org.apache.inlong.tubemq.manager.controller.group.request.BatchDeleteGroupReq;
import org.apache.inlong.tubemq.manager.controller.group.request.DeleteBlackGroupReq;
import org.apache.inlong.tubemq.manager.controller.group.request.DeleteOffsetReq;
import org.apache.inlong.tubemq.manager.controller.group.request.FilterCondGroupReq;
import org.apache.inlong.tubemq.manager.controller.group.request.FlowControlGroupReq;
import org.apache.inlong.tubemq.manager.controller.group.request.QueryConsumerGroupReq;
import org.apache.inlong.tubemq.manager.controller.group.request.QueryOffsetReq;
import org.apache.inlong.tubemq.manager.controller.node.request.BaseReq;
import org.apache.inlong.tubemq.manager.controller.node.request.CloneOffsetReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.BatchAddGroupAuthReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.DeleteGroupReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.RebalanceConsumerReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.RebalanceGroupReq;
import org.apache.inlong.tubemq.manager.service.TopicServiceImpl;
import org.apache.inlong.tubemq.manager.service.interfaces.MasterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/v1/group"})
public class GroupController {
    private static final Logger log = LoggerFactory.getLogger(GroupController.class);
    private Gson gson = new Gson();
    @Autowired
    private MasterService masterService;
    @Autowired
    private TopicServiceImpl topicService;

    @ResponseBody
    @PostMapping(value={""})
    public TubeMQResult groupMethodProxy(@RequestParam String method, @RequestBody String req) {
        switch (method) {
            case "add": {
                return this.batchAddGroup((BatchAddGroupAuthReq)this.gson.fromJson(req, BatchAddGroupAuthReq.class));
            }
            case "delete": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, DeleteGroupReq.class));
            }
            case "batchDelete": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, BatchDeleteGroupReq.class));
            }
            case "rebalanceGroup": {
                return this.topicService.rebalanceGroup((RebalanceGroupReq)this.gson.fromJson(req, RebalanceGroupReq.class));
            }
            case "rebalanceConsumer": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, RebalanceConsumerReq.class));
            }
            case "filterCondition": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, FilterCondGroupReq.class));
            }
            case "flowControl": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, FlowControlGroupReq.class));
            }
            case "query": {
                return this.queryGroupExist((QueryConsumerGroupReq)this.gson.fromJson(req, QueryConsumerGroupReq.class));
            }
        }
        return TubeMQResult.errorResult("no such method");
    }

    private TubeMQResult queryGroupExist(QueryConsumerGroupReq req) {
        if (!req.legal()) {
            return TubeMQResult.errorResult("param illegal");
        }
        return this.topicService.queryGroupExist(req);
    }

    private TubeMQResult batchAddGroup(BatchAddGroupAuthReq req) {
        req.setMethod("admin_bath_add_authorized_consumergroup_info");
        req.setType("op_modify");
        req.setCreateUser("tubeAdmin");
        return this.masterService.baseRequestMaster(req);
    }

    @GetMapping(value={"/"})
    @ResponseBody
    public String queryConsumer(@RequestParam Map<String, String> req) throws Exception {
        String url = this.masterService.getQueryUrl(req);
        return this.masterService.queryMaster(url);
    }

    @PostMapping(value={"/offset"})
    @ResponseBody
    public TubeMQResult offsetProxy(@RequestParam String method, @RequestBody String req) {
        switch (method) {
            case "clone": {
                return this.topicService.cloneOffsetToOtherGroups((CloneOffsetReq)this.gson.fromJson(req, CloneOffsetReq.class));
            }
            case "delete": {
                return this.topicService.deleteOffset((DeleteOffsetReq)this.gson.fromJson(req, DeleteOffsetReq.class));
            }
            case "query": {
                return this.topicService.queryOffset((QueryOffsetReq)this.gson.fromJson(req, QueryOffsetReq.class));
            }
        }
        return TubeMQResult.errorResult("no such method");
    }

    @PostMapping(value={"/blackGroup"})
    @ResponseBody
    public TubeMQResult blackGroupProxy(@RequestParam String method, @RequestBody String req) {
        switch (method) {
            case "add": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, AddBlackGroupReq.class));
            }
            case "delete": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, DeleteBlackGroupReq.class));
            }
            case "batchDelete": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, BatchDeleteGroupReq.class));
            }
        }
        return TubeMQResult.errorResult("no such method");
    }

    @GetMapping(value={"/blackGroup"})
    @ResponseBody
    public String queryBlackGroup(@RequestParam Map<String, String> req) throws Exception {
        String url = this.masterService.getQueryUrl(req);
        return this.masterService.queryMaster(url);
    }
}

