/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"power"}, parameter="(Numeric numeric1, Numeric numeric2)", descriptions={"- Return \"\" if any parameter is NULL.", "- Return 'numeric1'.power('numeric2')."}, examples={"power(4,0.5) = 2.0"})
public class PowerFunction
implements ValueParser {
    private ValueParser baseParser;
    private ValueParser exponentParser;

    public PowerFunction(Function expr) {
        this.baseParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
        this.exponentParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object baseObj = this.baseParser.parse(sourceData, rowIndex, context);
        Object exponentObj = this.exponentParser.parse(sourceData, rowIndex, context);
        if (baseObj == null || exponentObj == null) {
            return null;
        }
        BigDecimal baseValue = OperatorTools.parseBigDecimal(baseObj);
        BigDecimal exponentValue = OperatorTools.parseBigDecimal(exponentObj);
        return Math.pow(baseValue.doubleValue(), exponentValue.doubleValue());
    }
}

