/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.reader.kafka;

import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Properties;
import java.util.Queue;
import org.apache.hugegraph.loader.exception.InitException;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.parser.CsvLineParser;
import org.apache.hugegraph.loader.parser.JsonLineParser;
import org.apache.hugegraph.loader.parser.LineParser;
import org.apache.hugegraph.loader.parser.TextLineParser;
import org.apache.hugegraph.loader.reader.AbstractReader;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.loader.source.file.FileFormat;
import org.apache.hugegraph.loader.source.kafka.KafkaSource;
import org.apache.hugegraph.util.Log;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;

public class KafkaReader
extends AbstractReader {
    private static final Logger LOG = Log.logger(KafkaReader.class);
    private final KafkaSource source;
    private final LineParser parser;
    private Queue<String> batch;
    private static final String BASE_CONSUMER_GROUP = "kafka-reader-base";
    private final KafkaConsumer dataConsumer;
    private final boolean earlyStop;
    private boolean emptyPoll;

    public KafkaReader(KafkaSource source) {
        this.source = source;
        this.dataConsumer = this.createKafkaConsumer();
        this.parser = this.createLineParser();
        this.earlyStop = source.isEarlyStop();
    }

    @Override
    public void init(LoadContext context, InputStruct struct) throws InitException {
        this.progress(context, struct);
    }

    @Override
    public void confirmOffset() {
    }

    @Override
    public void close() {
        this.dataConsumer.close();
    }

    @Override
    public boolean multiReaders() {
        return false;
    }

    @Override
    public boolean hasNext() {
        return !this.earlyStop || !this.emptyPoll;
    }

    @Override
    public Line next() {
        String rawValue;
        if (this.batch == null || this.batch.size() == 0) {
            this.batch = this.nextBatch();
        }
        if ((rawValue = this.batch.poll()) != null) {
            return this.parser.parse(this.source.header(), rawValue);
        }
        this.emptyPoll = true;
        return null;
    }

    private int getKafkaTopicPartitionCount() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.source.getBootstrapServer());
        props.put("group.id", BASE_CONSUMER_GROUP);
        KafkaConsumer consumer = new KafkaConsumer(props);
        int count = consumer.partitionsFor(this.source.getTopic()).size();
        consumer.close();
        return count;
    }

    private KafkaConsumer<String, String> createKafkaConsumer() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.source.getBootstrapServer());
        props.put("max.poll.records", (Object)this.source.getBatchSize());
        props.put("group.id", this.source.getGroup());
        props.put("enable.auto.commit", "true");
        props.put("auto.commit.interval.ms", String.valueOf(1000L));
        props.put("session.timeout.ms", String.valueOf(30000L));
        if (this.source.isFromBeginning()) {
            props.put("auto.offset.reset", "earliest");
        } else {
            props.put("auto.offset.reset", "latest");
        }
        props.put("key.deserializer", StringDeserializer.class.getName());
        props.put("value.deserializer", StringDeserializer.class.getName());
        KafkaConsumer consumer = new KafkaConsumer(props);
        consumer.subscribe((Collection)ImmutableList.of((Object)this.source.getTopic()));
        return consumer;
    }

    private Deque<String> nextBatch() {
        ConsumerRecords records = this.dataConsumer.poll(Duration.ofMillis(1000L));
        ArrayDeque<String> queue = new ArrayDeque<String>(records.count());
        if (records.count() == 0) {
            Thread.sleep(1000L);
        } else {
            for (ConsumerRecord record : records) {
                queue.add((String)record.value());
            }
        }
        return queue;
    }

    private LineParser createLineParser() {
        FileFormat format = this.source.getFormat();
        switch (format) {
            case CSV: {
                return new CsvLineParser();
            }
            case TEXT: {
                return new TextLineParser(this.source.getDelimiter());
            }
            case JSON: {
                return new JsonLineParser();
            }
        }
        throw new AssertionError((Object)String.format("Unsupported file format '%s' of source '%s'", new Object[]{format, this.source}));
    }
}

