/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.UUID;
import org.simpleflatmapper.csv.CellValueReader;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.lightningcsv.parser.CellConsumer;
import org.simpleflatmapper.lightningcsv.parser.CharBuffer;
import org.simpleflatmapper.util.CharSequenceImpl;

public final class CsvRow
implements CellConsumer {
    private final CsvColumnKey[] keys;
    private final int nbColumns;
    private final CharBuffer charBuffer;
    protected int[] fieldsBoundaries;
    protected int currentIndex;
    protected int rowStartMark;
    private static final int radix = 10;

    public CsvRow(CsvColumnKey[] keys, int maxIndex, CharBuffer charBuffer) {
        this.nbColumns = maxIndex + 1;
        this.keys = keys;
        this.charBuffer = charBuffer;
        this.fieldsBoundaries = new int[this.nbColumns * 2];
    }

    public int getIndex(String column) {
        for (CsvColumnKey key : this.keys) {
            if (!key.getName().equals(column)) continue;
            return key.getIndex();
        }
        return -1;
    }

    public CsvColumnKey[] getKeys() {
        return this.keys;
    }

    public void reset() {
        int[] fieldsBoundaries = this.fieldsBoundaries;
        for (int i = 0; i < fieldsBoundaries.length; ++i) {
            fieldsBoundaries[i] = 0;
        }
        this.currentIndex = 0;
    }

    public void addValue(int offset, int length) {
        int index = this.currentIndex;
        int[] fieldsBoundaries = this.fieldsBoundaries;
        if (index + 1 < fieldsBoundaries.length) {
            fieldsBoundaries[index] = offset;
            fieldsBoundaries[index + 1] = length;
            this.currentIndex = index + 2;
        }
    }

    public <T> T read(CellValueReader<T> cellValueReader, int i) {
        int rowOffset = this.fieldsBoundaries[i * 2];
        int length = this.fieldsBoundaries[i * 2 + 1];
        return cellValueReader.read(this.charBuffer.buffer, this.rowStartMark + rowOffset, length, null);
    }

    public CharSequence getCharSequence(int i) {
        int length = this.fieldsBoundaries[i * 2 + 1];
        if (length == 0) {
            return null;
        }
        int rowOffset = this.fieldsBoundaries[i * 2];
        return new CharSequenceImpl(this.charBuffer.buffer, this.rowStartMark + rowOffset, this.rowStartMark + rowOffset + length);
    }

    public String getString(int i) {
        int length = this.fieldsBoundaries[i * 2 + 1];
        if (length == 0) {
            return null;
        }
        int rowOffset = this.fieldsBoundaries[i * 2];
        return new String(this.charBuffer.buffer, this.rowStartMark + rowOffset, length);
    }

    public int length(int i) {
        return this.fieldsBoundaries[i * 2 + 1];
    }

    private boolean isEmpty(int i) {
        return this.length(i) == 0;
    }

    public byte getByte(int i) {
        if (this.isEmpty(i)) {
            return 0;
        }
        return Byte.parseByte(this.getString(i));
    }

    public char getChar(int i) {
        if (this.isEmpty(i)) {
            return '\u0000';
        }
        return (char)Integer.parseInt(this.getString(i));
    }

    public short getShort(int i) {
        if (this.isEmpty(i)) {
            return 0;
        }
        return Short.parseShort(this.getString(i));
    }

    public int getInt(int i) {
        int rowOffset = this.fieldsBoundaries[i * 2];
        int length = this.fieldsBoundaries[i * 2 + 1];
        return CsvRow.parseInt(this.charBuffer.buffer, this.rowStartMark + rowOffset, this.rowStartMark + rowOffset + length);
    }

    public long getLong(int i) {
        int rowOffset = this.fieldsBoundaries[i * 2];
        int length = this.fieldsBoundaries[i * 2 + 1];
        return CsvRow.parseLong(this.charBuffer.buffer, this.rowStartMark + rowOffset, this.rowStartMark + rowOffset + length);
    }

    public float getFloat(int i) {
        if (this.isEmpty(i)) {
            return 0.0f;
        }
        return Float.parseFloat(this.getString(i));
    }

    public double getDouble(int i) {
        if (this.isEmpty(i)) {
            return 0.0;
        }
        return Double.parseDouble(this.getString(i));
    }

    public boolean getBoolean(int i) {
        if (this.isEmpty(i)) {
            return false;
        }
        int rowOffset = this.fieldsBoundaries[i * 2];
        int length = this.fieldsBoundaries[i * 2 + 1];
        return CsvRow.parseBoolean(this.charBuffer.buffer, this.rowStartMark + rowOffset, length);
    }

    public static boolean parseBoolean(char[] chars, int offset, int length) {
        switch (length) {
            case 0: {
                return false;
            }
            case 1: {
                switch (chars[offset]) {
                    case '\u0000': 
                    case '0': 
                    case 'F': 
                    case 'N': 
                    case 'f': 
                    case 'n': {
                        return false;
                    }
                }
                return true;
            }
            case 2: {
                if (!(chars[offset] != 'N' && chars[offset] != 'n' || chars[offset + 1] != 'O' && chars[offset + 1] != 'o')) {
                    return false;
                }
            }
            case 5: {
                if (chars[offset] != 'F' && chars[offset] != 'f' || chars[offset + 1] != 'A' && chars[offset + 1] != 'a' || chars[offset + 2] != 'L' && chars[offset + 2] != 'l' || chars[offset + 3] != 'S' && chars[offset + 3] != 's' || chars[offset + 4] != 'E' && chars[offset + 4] != 'e') break;
                return false;
            }
        }
        return true;
    }

    public Byte getBoxedByte(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return this.getByte(i);
    }

    public Short getBoxedShort(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return this.getShort(i);
    }

    public Character getBoxedChar(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return Character.valueOf(this.getChar(i));
    }

    public Integer getBoxedInt(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return this.getInt(i);
    }

    public Long getBoxedLong(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return this.getLong(i);
    }

    public Float getBoxedFloat(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return Float.valueOf(this.getFloat(i));
    }

    public Double getBoxedDouble(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return this.getDouble(i);
    }

    public Boolean getBoxedBoolean(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return this.getBoolean(i);
    }

    public BigDecimal getBigDecimal(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return new BigDecimal(this.getString(i));
    }

    public BigInteger getBigInteger(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return new BigInteger(this.getString(i));
    }

    public UUID getUUID(int i) {
        if (this.isEmpty(i)) {
            return null;
        }
        return UUID.fromString(this.getString(i));
    }

    public int getNbColumns() {
        return this.nbColumns;
    }

    public boolean hasData() {
        return this.currentIndex > 0;
    }

    public boolean containsOnly(char c) {
        for (int column = 0; column < this.nbColumns; ++column) {
            int start = this.fieldsBoundaries[column * 2];
            int end = start + this.fieldsBoundaries[column * 2 + 1];
            for (int i = start; i < end; ++i) {
                if (this.charBuffer.buffer[this.rowStartMark + i] == c) continue;
                return false;
            }
        }
        return true;
    }

    public void newCell(char[] chars, int offset, int length) {
        int index = this.currentIndex;
        int[] fieldsBoundaries = this.fieldsBoundaries;
        if (index + 1 < fieldsBoundaries.length) {
            fieldsBoundaries[index] = offset - this.charBuffer.rowStartMark;
            fieldsBoundaries[index + 1] = length;
            this.currentIndex = index + 2;
        }
    }

    public boolean endOfRow() {
        this.rowStartMark = this.charBuffer.rowStartMark;
        return true;
    }

    public void end() {
        this.rowStartMark = this.charBuffer.rowStartMark;
    }

    public static int parseInt(char[] s, int beginIndex, int endIndex) throws NumberFormatException {
        s = Objects.requireNonNull(s);
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > s.length) {
            throw new IndexOutOfBoundsException();
        }
        boolean negative = false;
        int i = beginIndex;
        int limit = -2147483647;
        if (i < endIndex) {
            char firstChar = s[i];
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw CsvRow.numberFormatExceptionforCharSequence(s, beginIndex, endIndex, i);
                }
                if (++i == endIndex) {
                    throw CsvRow.numberFormatExceptionforCharSequence(s, beginIndex, endIndex, i);
                }
            }
            int multmin = limit / 10;
            int result = 0;
            while (i < endIndex) {
                int digit = CsvRow.digit(s[i]);
                if (digit < 0 || result < multmin) {
                    throw CsvRow.numberFormatExceptionforCharSequence(s, beginIndex, endIndex, i);
                }
                if ((result *= 10) < limit + digit) {
                    throw CsvRow.numberFormatExceptionforCharSequence(s, beginIndex, endIndex, i);
                }
                ++i;
                result -= digit;
            }
            return negative ? result : -result;
        }
        return 0;
    }

    private static int digit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        return Character.digit(c, 10);
    }

    public static long parseLong(char[] s, int beginIndex, int endIndex) throws NumberFormatException {
        s = Objects.requireNonNull(s);
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > s.length) {
            throw new IndexOutOfBoundsException();
        }
        boolean negative = false;
        int i = beginIndex;
        long limit = -9223372036854775807L;
        if (i < endIndex) {
            char firstChar = s[i];
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw CsvRow.numberFormatExceptionforCharSequence(s, beginIndex, endIndex, i);
                }
                ++i;
            }
            if (i >= endIndex) {
                throw CsvRow.numberFormatExceptionforCharSequence(s, beginIndex, endIndex, i);
            }
            long multmin = limit / 10L;
            long result = 0L;
            while (i < endIndex) {
                int digit = CsvRow.digit(s[i]);
                if (digit < 0 || result < multmin) {
                    throw CsvRow.numberFormatExceptionforCharSequence(s, beginIndex, endIndex, i);
                }
                if ((result *= 10L) < limit + (long)digit) {
                    throw CsvRow.numberFormatExceptionforCharSequence(s, beginIndex, endIndex, i);
                }
                ++i;
                result -= (long)digit;
            }
            return negative ? result : -result;
        }
        return 0L;
    }

    private static NumberFormatException numberFormatExceptionforCharSequence(char[] chars, int beginIndex, int endIndex, int errorIndex) {
        return new NumberFormatException("Error at index " + (errorIndex - beginIndex) + " in: \"" + new String(chars, beginIndex, endIndex - beginIndex) + "\"");
    }
}

