/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.NoSuchElementException;

public interface LongIterator {
    public boolean hasNext();

    public long next();

    public static LongIterator fromRange(final long startInclusive, final long endExclusive) {
        return new LongIterator(){
            private long i;
            {
                this.i = startInclusive;
            }

            @Override
            public boolean hasNext() {
                return this.i < endExclusive;
            }

            @Override
            public long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.i++;
            }
        };
    }

    public static LongIterator fromArray(final long[] longs) {
        return new LongIterator(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < longs.length;
            }

            @Override
            public long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return longs[this.i++];
            }
        };
    }
}

