/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.replicator;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.placementdriver.message.PlacementDriverReplicaMessage;
import org.apache.ignite3.internal.raft.Peer;
import org.apache.ignite3.internal.raft.PeersAndLearners;
import org.apache.ignite3.internal.raft.client.TopologyAwareRaftGroupService;
import org.apache.ignite3.internal.replicator.Member;
import org.apache.ignite3.internal.replicator.PlacementDriverMessageProcessor;
import org.apache.ignite3.internal.replicator.Replica;
import org.apache.ignite3.internal.replicator.ReplicaResult;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.listener.ReplicaListener;
import org.apache.ignite3.internal.replicator.message.ReplicaRequest;
import org.apache.ignite3.internal.util.CompletableFutures;

public class ZonePartitionReplicaImpl
implements Replica {
    private final ReplicationGroupId replicaGrpId;
    private final ReplicaListener listener;
    private final TopologyAwareRaftGroupService raftClient;
    private final PlacementDriverMessageProcessor placementDriverMessageProcessor;

    public ZonePartitionReplicaImpl(ReplicationGroupId replicaGrpId, ReplicaListener listener, TopologyAwareRaftGroupService raftClient, PlacementDriverMessageProcessor placementDriverMessageProcessor) {
        this.replicaGrpId = replicaGrpId;
        this.listener = listener;
        this.raftClient = raftClient;
        this.placementDriverMessageProcessor = placementDriverMessageProcessor;
    }

    @Override
    public ReplicaListener listener() {
        return this.listener;
    }

    @Override
    public TopologyAwareRaftGroupService raftClient() {
        return this.raftClient;
    }

    @Override
    public CompletableFuture<ReplicaResult> processRequest(ReplicaRequest request, UUID senderId) {
        return this.listener.invoke(request, senderId);
    }

    @Override
    public ReplicationGroupId groupId() {
        return this.replicaGrpId;
    }

    @Override
    public CompletableFuture<? extends NetworkMessage> processPlacementDriverMessage(PlacementDriverReplicaMessage msg) {
        return this.placementDriverMessageProcessor.processPlacementDriverMessage(msg);
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        this.listener.onShutdown();
        this.raftClient.unsubscribeLeader();
        this.raftClient.shutdown();
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public void updatePeersAndLearners(PeersAndLearners peersAndLearners) {
        this.raftClient.updateConfiguration(peersAndLearners);
    }

    @Override
    public CompletableFuture<Void> createSnapshotOn(Member targetMember, boolean forced) {
        Peer peer = targetMember.isVotingMember() ? new Peer(targetMember.consistentId(), 0) : new Peer(targetMember.consistentId(), 1);
        return this.raftClient.snapshot(peer, forced);
    }

    @Override
    public CompletableFuture<Void> transferLeadershipTo(String targetConsistentId) {
        return this.raftClient.transferLeadership(new Peer(targetConsistentId));
    }
}

