/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.network.configuration.InboundView;
import org.apache.ignite3.internal.network.configuration.NetworkConfiguration;
import org.apache.ignite3.internal.network.configuration.NetworkView;
import org.apache.ignite3.internal.network.configuration.OutboundView;
import org.apache.ignite3.internal.network.handshake.HandshakeEventLoopSwitcher;
import org.apache.ignite3.internal.network.netty.NamedNioEventLoopGroup;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.jetbrains.annotations.TestOnly;

public class NettyBootstrapFactory
implements IgniteComponent {
    private final NetworkConfiguration networkConfiguration;
    private final String eventLoopGroupNamePrefix;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private volatile HandshakeEventLoopSwitcher handshakeEventLoopSwitcher;

    public NettyBootstrapFactory(NetworkConfiguration networkConfiguration, String eventLoopGroupNamePrefix) {
        assert (eventLoopGroupNamePrefix != null);
        assert (networkConfiguration != null);
        this.networkConfiguration = networkConfiguration;
        this.eventLoopGroupNamePrefix = eventLoopGroupNamePrefix;
    }

    public Bootstrap createOutboundBootstrap() {
        OutboundView outboundConfiguration = ((NetworkView)this.networkConfiguration.value()).outbound();
        Bootstrap outboundBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)outboundBootstrap.group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)outboundConfiguration.soKeepAlive())).option(ChannelOption.SO_LINGER, (Object)outboundConfiguration.soLinger())).option(ChannelOption.TCP_NODELAY, (Object)outboundConfiguration.tcpNoDelay());
        return outboundBootstrap;
    }

    public ServerBootstrap createServerBootstrap() {
        InboundView serverConfiguration = ((NetworkView)this.networkConfiguration.value()).inbound();
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)serverConfiguration.soBacklog())).option(ChannelOption.SO_REUSEADDR, (Object)serverConfiguration.soReuseAddr())).childOption(ChannelOption.SO_KEEPALIVE, (Object)serverConfiguration.soKeepAlive()).childOption(ChannelOption.SO_LINGER, (Object)serverConfiguration.soLinger()).childOption(ChannelOption.TCP_NODELAY, (Object)serverConfiguration.tcpNoDelay());
        return serverBootstrap;
    }

    List<EventLoopGroup> eventLoopGroupsForBlockedThreadsDetection() {
        return List.of(this.workerGroup);
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.bossGroup = NamedNioEventLoopGroup.create(this.eventLoopGroupNamePrefix + "-network-accept");
        this.workerGroup = NamedNioEventLoopGroup.create(this.eventLoopGroupNamePrefix + "-network-worker");
        this.handshakeEventLoopSwitcher = new HandshakeEventLoopSwitcher(NettyBootstrapFactory.eventLoopsAt(this.workerGroup));
        return CompletableFutures.nullCompletedFuture();
    }

    public HandshakeEventLoopSwitcher handshakeEventLoopSwitcher() {
        return this.handshakeEventLoopSwitcher;
    }

    private static List<EventLoop> eventLoopsAt(EventLoopGroup ... groups) {
        ArrayList<EventLoop> channelEventLoops = new ArrayList<EventLoop>();
        for (EventLoopGroup group : groups) {
            for (EventExecutor child : group) {
                channelEventLoops.add((EventLoop)child);
            }
        }
        return channelEventLoops;
    }

    public static boolean isInNetworkThread() {
        Thread thread = Thread.currentThread();
        return thread instanceof NamedNioEventLoopGroup.NetworkThread;
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        NetworkView configurationView = (NetworkView)this.networkConfiguration.value();
        long quietPeriod = configurationView.shutdownQuietPeriodMillis();
        long shutdownTimeout = configurationView.shutdownTimeoutMillis();
        try {
            this.workerGroup.shutdownGracefully(quietPeriod, shutdownTimeout, TimeUnit.MILLISECONDS).sync();
            this.bossGroup.shutdownGracefully(quietPeriod, shutdownTimeout, TimeUnit.MILLISECONDS).sync();
        }
        catch (InterruptedException e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @TestOnly
    public EventLoopGroup workerEventLoopGroup() {
        return this.workerGroup;
    }
}

