/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite3.deployment.DeploymentUnit;
import org.apache.ignite3.internal.deployunit.DeploymentUnitAccessor;
import org.apache.ignite3.internal.deployunit.DisposableDeploymentUnit;
import org.apache.ignite3.internal.deployunit.FileDeployerService;
import org.apache.ignite3.internal.util.RefCountedObjectPool;

public class DeploymentUnitAccessorImpl
implements DeploymentUnitAccessor {
    private final RefCountedObjectPool<DeploymentUnit, DisposableDeploymentUnit> pool = new RefCountedObjectPool();
    private final RefCountedObjectPool<DeploymentUnit, Lock> locks = new RefCountedObjectPool();
    private final FileDeployerService deployer;

    public DeploymentUnitAccessorImpl(FileDeployerService deployer) {
        this.deployer = deployer;
    }

    @Override
    public DisposableDeploymentUnit acquire(DeploymentUnit unit) {
        return this.executeWithLock(unit, it -> this.pool.acquire((DeploymentUnit)it, ignored -> new DisposableDeploymentUnit((DeploymentUnit)it, this.deployer.unitPath(it.name(), it.version(), true), () -> this.pool.release((DeploymentUnit)it))));
    }

    @Override
    public boolean computeIfNotAcquired(DeploymentUnit unit, Consumer<DeploymentUnit> consumer) {
        return this.executeWithLock(unit, it -> {
            if (this.pool.isAcquired((DeploymentUnit)it)) {
                return false;
            }
            consumer.accept((DeploymentUnit)it);
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <O> O executeWithLock(DeploymentUnit unit, Function<DeploymentUnit, O> function) {
        Lock lock = this.locks.acquire(unit, ignored -> new ReentrantLock());
        lock.lock();
        try {
            O o = function.apply(unit);
            return o;
        }
        finally {
            lock.unlock();
            this.locks.release(unit);
        }
    }
}

