/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteDiagnosticInfo;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.jetbrains.annotations.Nullable;

public class IgniteDiagnosticMessage
implements Message {
    private static final long serialVersionUID = 0L;
    private static final int REQUEST_FLAG_MASK = 1;
    private byte flags;
    private long futId;
    private byte[] bytes;

    public static IgniteDiagnosticMessage createRequest(Marshaller marsh, IgniteClosure<GridKernalContext, IgniteDiagnosticInfo> c, long futId) throws IgniteCheckedException {
        byte[] cBytes = U.marshal(marsh, c);
        IgniteDiagnosticMessage msg = new IgniteDiagnosticMessage();
        msg.futId = futId;
        msg.bytes = cBytes;
        msg.flags = (byte)(msg.flags | 1);
        return msg;
    }

    public static IgniteDiagnosticMessage createResponse(byte[] resBytes, long futId) {
        IgniteDiagnosticMessage msg = new IgniteDiagnosticMessage();
        msg.futId = futId;
        msg.bytes = resBytes;
        return msg;
    }

    @Nullable
    public <T> T unmarshal(Marshaller marsh) throws IgniteCheckedException {
        if (this.bytes == null) {
            return null;
        }
        return U.unmarshal(marsh, this.bytes, null);
    }

    public long futureId() {
        return this.futId;
    }

    public boolean request() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("bytes", this.bytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.bytes = reader.readByteArray("bytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(IgniteDiagnosticMessage.class);
    }

    @Override
    public short directType() {
        return -61;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    @Override
    public void onAckReceived() {
    }

    static void dumpNodeBasicInfo(StringBuilder sb, GridKernalContext ctx) {
        sb.append("General node info [id=").append(ctx.localNodeId()).append(", client=").append(ctx.clientNode()).append(", discoTopVer=").append(ctx.discovery().topologyVersionEx()).append(", time=").append(IgniteDiagnosticMessage.formatTime(U.currentTimeMillis())).append(']');
    }

    static void dumpExchangeInfo(StringBuilder sb, GridKernalContext ctx) {
        GridCachePartitionExchangeManager exchMgr = ctx.cache().context().exchange();
        GridDhtPartitionsExchangeFuture fut = exchMgr.lastTopologyFuture();
        sb.append("Partitions exchange info [readyVer=").append(exchMgr.readyAffinityVersion()).append(']').append(U.nl()).append("Last initialized exchange future: ").append(fut);
    }

    static void dumpPendingCacheMessages(StringBuilder sb, GridKernalContext ctx) {
        ctx.cache().context().io().dumpPendingMessages(sb);
    }

    public static IgniteInternalFuture<String> dumpCommunicationInfo(GridKernalContext ctx, UUID nodeId) {
        if (ctx.config().getCommunicationSpi() instanceof TcpCommunicationSpi) {
            return ((TcpCommunicationSpi)ctx.config().getCommunicationSpi()).dumpNodeStatistics(nodeId);
        }
        return new GridFinishedFuture<CallSite>((CallSite)((Object)("Unexpected communication SPI: " + ctx.config().getCommunicationSpi())));
    }

    private static String formatTime(long time) {
        return IgniteUtils.DEBUG_DATE_FMT.format(Instant.ofEpochMilli(time));
    }

    public String toString() {
        return S.toString(IgniteDiagnosticMessage.class, this);
    }

    public static final class TxInfoClosure
    extends DiagnosticBaseClosure {
        private static final long serialVersionUID = 0L;
        private final GridCacheVersion dhtVer;
        private final GridCacheVersion nearVer;

        TxInfoClosure(GridCacheVersion dhtVer, GridCacheVersion nearVer) {
            this.dhtVer = dhtVer;
            this.nearVer = nearVer;
        }

        @Override
        public void apply(StringBuilder sb, GridKernalContext ctx) {
            sb.append(U.nl()).append("Related transactions [dhtVer=").append(this.dhtVer).append(", nearVer=").append(this.nearVer).append("]: ");
            boolean found = false;
            for (IgniteInternalTx tx : ctx.cache().context().tm().activeTransactions()) {
                if (!this.dhtVer.equals(tx.xidVersion()) && !this.nearVer.equals(tx.nearXidVersion())) continue;
                sb.append(U.nl()).append("    ").append(tx.getClass().getSimpleName()).append(" [ver=").append(tx.xidVersion()).append(", nearVer=").append(tx.nearXidVersion()).append(", topVer=").append(tx.topologyVersion()).append(", state=").append((Object)tx.state()).append(", fullTx=").append(tx).append(']');
                found = true;
            }
            if (!found) {
                sb.append(U.nl()).append("Failed to find related transactions.");
            }
        }

        @Override
        public Object mergeKey() {
            return new T3(this.getClass(), this.nearVer, this.dhtVer);
        }
    }

    public static final class ExchangeInfoClosure
    extends DiagnosticBaseClosure {
        private static final long serialVersionUID = 0L;
        private final AffinityTopologyVersion topVer;

        ExchangeInfoClosure(AffinityTopologyVersion topVer) {
            this.topVer = topVer;
        }

        @Override
        public void apply(StringBuilder sb, GridKernalContext ctx) {
            sb.append(U.nl());
            List<GridDhtPartitionsExchangeFuture> futs = ctx.cache().context().exchange().exchangeFutures();
            for (GridDhtPartitionsExchangeFuture fut : futs) {
                if (!this.topVer.equals(fut.initialVersion())) continue;
                sb.append("Exchange future: ").append(fut);
                return;
            }
            sb.append("Failed to find exchange future: ").append(this.topVer);
        }

        @Override
        public Object mergeKey() {
            return new T2(this.getClass(), this.topVer);
        }
    }

    public static final class TxEntriesInfoClosure
    extends DiagnosticBaseClosure {
        private static final long serialVersionUID = 0L;
        private final int cacheId;
        private Collection<KeyCacheObject> keys;

        TxEntriesInfoClosure(int cacheId, Collection<KeyCacheObject> keys) {
            this.cacheId = cacheId;
            this.keys = new HashSet<KeyCacheObject>(keys);
        }

        @Override
        public void apply(StringBuilder sb, GridKernalContext ctx) {
            sb.append(U.nl());
            GridCacheContext cctx = ctx.cache().context().cacheContext(this.cacheId);
            if (cctx == null) {
                sb.append("Failed to find cache with id: ").append(this.cacheId);
                return;
            }
            try {
                for (KeyCacheObject key : this.keys) {
                    key.finishUnmarshal(cctx.cacheObjectContext(), null);
                }
            }
            catch (IgniteCheckedException e) {
                ctx.cluster().diagnosticLog().error("Failed to unmarshal key: " + e, e);
                sb.append("Failed to unmarshal key: ").append(e).append(U.nl());
            }
            sb.append("Cache entries [cacheId=").append(this.cacheId).append(", cacheName=").append(cctx.name()).append("]: ");
            for (KeyCacheObject key : this.keys) {
                GridCacheMapEntry e = (GridCacheMapEntry)cctx.cache().peekEx(key);
                sb.append(U.nl()).append("    Key [key=").append(key).append(", entry=").append(e).append("]");
            }
        }

        @Override
        public Object mergeKey() {
            return new T2(this.getClass(), this.cacheId);
        }

        @Override
        public void merge(DiagnosticBaseClosure other) {
            TxEntriesInfoClosure other0 = (TxEntriesInfoClosure)other;
            assert (other0 != null && this.cacheId == other0.cacheId) : other;
            this.keys.addAll(other0.keys);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.keys = new ArrayList<KeyCacheObject>(this.keys);
            out.defaultWriteObject();
        }
    }

    public static abstract class DiagnosticBaseClosure
    implements IgniteBiInClosure<StringBuilder, GridKernalContext> {
        public Object mergeKey() {
            return this.getClass();
        }

        public void merge(DiagnosticBaseClosure other) {
        }
    }
}

