/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.messages;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class StatisticsDecimalMessage
implements Message {
    private static final long serialVersionUID = 0L;
    public static final short TYPE_CODE = 184;
    private int scale;
    private byte[] b;

    public StatisticsDecimalMessage() {
    }

    public StatisticsDecimalMessage(BigDecimal val) {
        if (val == null) {
            this.scale = 0;
            this.b = null;
        } else {
            this.scale = val.scale();
            this.b = val.unscaledValue().toByteArray();
        }
    }

    public BigDecimal value() {
        if (this.b == null && this.scale == 0) {
            return null;
        }
        return new BigDecimal(new BigInteger(this.b), this.scale);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("b", this.b)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeInt("scale", this.scale)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.b = reader.readByteArray("b");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.scale = reader.readInt("scale");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(StatisticsDecimalMessage.class);
    }

    @Override
    public short directType() {
        return 184;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return Objects.toString(this.value());
    }
}

