/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Hasher {
    private static final int SEED = 123456;
    private static final int CHUNK_SIZE = 16;
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;
    private long h1;
    private long h2;
    private int len;

    public long fastHash(byte[] arr) {
        return this.fastHash(arr, 0, arr.length);
    }

    public long fastHash(byte[] arr, int off, int len) {
        this.h1 = 123456L;
        this.h2 = 123456L;
        this.len = 0;
        ByteBuffer bb = ByteBuffer.wrap(arr, off, len).order(ByteOrder.LITTLE_ENDIAN);
        while (bb.remaining() >= 16) {
            this.process(bb);
        }
        if (bb.remaining() > 0) {
            this.processRemaining(bb);
        }
        return this.makeHash();
    }

    private void bmix64(long k1, long k2) {
        this.h1 ^= Hasher.mixK1(k1);
        this.h1 = Long.rotateLeft(this.h1, 27);
        this.h1 += this.h2;
        this.h1 = this.h1 * 5L + 1390208809L;
        this.h2 ^= Hasher.mixK2(k2);
        this.h2 = Long.rotateLeft(this.h2, 31);
        this.h2 += this.h1;
        this.h2 = this.h2 * 5L + 944331445L;
    }

    private void process(ByteBuffer bb) {
        long k1 = bb.getLong();
        long k2 = bb.getLong();
        this.bmix64(k1, k2);
        this.len += 16;
    }

    private static int toInt(byte val) {
        return val & 0xFF;
    }

    private void processRemaining(ByteBuffer bb) {
        long k1 = 0L;
        long k2 = 0L;
        this.len += bb.remaining();
        switch (bb.remaining()) {
            case 15: {
                k2 ^= (long)Hasher.toInt(bb.get(14)) << 48;
            }
            case 14: {
                k2 ^= (long)Hasher.toInt(bb.get(13)) << 40;
            }
            case 13: {
                k2 ^= (long)Hasher.toInt(bb.get(12)) << 32;
            }
            case 12: {
                k2 ^= (long)Hasher.toInt(bb.get(11)) << 24;
            }
            case 11: {
                k2 ^= (long)Hasher.toInt(bb.get(10)) << 16;
            }
            case 10: {
                k2 ^= (long)Hasher.toInt(bb.get(9)) << 8;
            }
            case 9: {
                k2 ^= (long)Hasher.toInt(bb.get(8));
            }
            case 8: {
                k1 ^= bb.getLong();
                break;
            }
            case 7: {
                k1 ^= (long)Hasher.toInt(bb.get(6)) << 48;
            }
            case 6: {
                k1 ^= (long)Hasher.toInt(bb.get(5)) << 40;
            }
            case 5: {
                k1 ^= (long)Hasher.toInt(bb.get(4)) << 32;
            }
            case 4: {
                k1 ^= (long)Hasher.toInt(bb.get(3)) << 24;
            }
            case 3: {
                k1 ^= (long)Hasher.toInt(bb.get(2)) << 16;
            }
            case 2: {
                k1 ^= (long)Hasher.toInt(bb.get(1)) << 8;
            }
            case 1: {
                k1 ^= (long)Hasher.toInt(bb.get(0));
                break;
            }
            default: {
                throw new AssertionError((Object)"Should never get here.");
            }
        }
        this.h1 ^= Hasher.mixK1(k1);
        this.h2 ^= Hasher.mixK2(k2);
    }

    private long makeHash() {
        this.h1 ^= (long)this.len;
        this.h2 ^= (long)this.len;
        this.h1 += this.h2;
        this.h2 += this.h1;
        this.h1 = Hasher.fmix64(this.h1);
        this.h2 = Hasher.fmix64(this.h2);
        this.h1 += this.h2;
        this.h2 += this.h1;
        return this.h1;
    }

    private static long fmix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    private static long mixK1(long k1) {
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        return k1 *= 5545529020109919103L;
    }

    private static long mixK2(long k2) {
        k2 *= 5545529020109919103L;
        k2 = Long.rotateLeft(k2, 33);
        return k2 *= -8663945395140668459L;
    }
}

