/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.datastructures;

import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;

public class PlatformAtomicSequence
extends PlatformAbstractTarget {
    private final IgniteAtomicSequence atomicSeq;
    private static final int OP_ADD_AND_GET = 1;
    private static final int OP_CLOSE = 2;
    private static final int OP_GET = 3;
    private static final int OP_GET_AND_ADD = 4;
    private static final int OP_GET_AND_INCREMENT = 5;
    private static final int OP_GET_BATCH_SIZE = 6;
    private static final int OP_INCREMENT_AND_GET = 7;
    private static final int OP_IS_CLOSED = 8;
    private static final int OP_SET_BATCH_SIZE = 9;

    public PlatformAtomicSequence(PlatformContext ctx, IgniteAtomicSequence atomicSeq) {
        super(ctx);
        assert (atomicSeq != null);
        this.atomicSeq = atomicSeq;
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 1: {
                return this.atomicSeq.addAndGet(val);
            }
            case 4: {
                return this.atomicSeq.getAndAdd(val);
            }
            case 9: {
                this.atomicSeq.batchSize((int)val);
                return 1L;
            }
            case 2: {
                this.atomicSeq.close();
                return 1L;
            }
            case 3: {
                return this.atomicSeq.get();
            }
            case 5: {
                return this.atomicSeq.getAndIncrement();
            }
            case 7: {
                return this.atomicSeq.incrementAndGet();
            }
            case 8: {
                return this.atomicSeq.removed() ? 1L : 0L;
            }
            case 6: {
                return this.atomicSeq.batchSize();
            }
        }
        return super.processInLongOutLong(type, val);
    }
}

