/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cacheobject;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectImpl;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class UserCacheObjectImpl
extends CacheObjectImpl {
    private static final long serialVersionUID = 0L;

    public UserCacheObjectImpl() {
    }

    public UserCacheObjectImpl(Object val, byte[] valBytes) {
        super(val, valBytes);
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectValueContext ctx, boolean cpy) {
        return super.value(ctx, false);
    }

    @Override
    public CacheObject prepareForCache(CacheObjectContext ctx) {
        try {
            IgniteCacheObjectProcessor proc = ctx.kernalContext().cacheObjects();
            if (this.valBytes == null) {
                this.valBytes = this.valueBytesFromValue(ctx);
            }
            if (ctx.storeValue()) {
                boolean p2pEnabled = ctx.kernalContext().config().isPeerClassLoadingEnabled();
                ClassLoader ldr = p2pEnabled ? IgniteUtils.detectClass(this.val).getClassLoader() : this.val.getClass().getClassLoader();
                Object val = this.val != null && proc.immutable(this.val) ? this.val : this.valueFromValueBytes(ctx, ldr);
                return new CacheObjectImpl(val, this.valBytes);
            }
            return new CacheObjectImpl(null, this.valBytes);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to marshal object: " + this.val, e);
        }
    }
}

