/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;

public class TransactionChanges<E> {
    private static final TransactionChanges<?> EMPTY = new TransactionChanges(Collections.emptySet(), Collections.emptyList());
    private final Set<KeyCacheObject> changedKeys;
    private final List<E> newAndUpdatedEntries;

    public TransactionChanges(Set<KeyCacheObject> changedKeys, List<E> newAndUpdatedEntries) {
        this.changedKeys = changedKeys;
        this.newAndUpdatedEntries = newAndUpdatedEntries;
    }

    public Set<KeyCacheObject> changedKeys() {
        return this.changedKeys;
    }

    public List<E> newAndUpdatedEntries() {
        return this.newAndUpdatedEntries;
    }

    public boolean changedKeysEmpty() {
        return this.changedKeys.isEmpty();
    }

    public boolean remove(KeyCacheObject key) {
        return this.changedKeys.remove(key);
    }

    public static <R> TransactionChanges<R> empty() {
        return EMPTY;
    }
}

