/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.store;

import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.MemoryCalculator;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageMetaInfoStore;
import org.jetbrains.annotations.Nullable;

public class HeapPageMetaInfoStore
implements PageMetaInfoStore {
    private static final int OVERHEAD_SIZE = 40;
    private static final int PAGE_ID_OFFSET = 0;
    private static final int PAGE_HEADER_ADDRESS_OFFSET = 1;
    private static final int PAGE_ADDRESS_OFFSET = 2;
    private static final int PAGE_META_OFFSET = 3;
    private static final int ITEM_SIZE = 4;
    private long[] arr;
    private final MemoryCalculator memoryCalc;

    public HeapPageMetaInfoStore(int capacity, @Nullable MemoryCalculator memoryCalc) {
        this.arr = new long[capacity * 4];
        this.memoryCalc = memoryCalc;
        if (memoryCalc != null) {
            memoryCalc.onHeapAllocated(this.arr.length * 8 + 40);
        }
    }

    HeapPageMetaInfoStore(long[] arr) {
        this.arr = arr;
        this.memoryCalc = null;
    }

    @Override
    public int capacity() {
        return this.arr.length / 4;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.arr.length; ++i) {
            if (this.arr[i] == 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(int itemIdx, int op, int structureId, long pageId, long pageAddrHeader, long pageAddr) {
        this.arr[4 * itemIdx + 0] = pageId;
        this.arr[4 * itemIdx + 1] = pageAddrHeader;
        this.arr[4 * itemIdx + 2] = pageAddr;
        this.arr[4 * itemIdx + 3] = this.meta(structureId, op);
    }

    @Override
    public void remove(int itemIdx) {
        this.arr[4 * itemIdx + 0] = 0L;
        this.arr[4 * itemIdx + 1] = 0L;
        this.arr[4 * itemIdx + 2] = 0L;
        this.arr[4 * itemIdx + 3] = 0L;
    }

    @Override
    public int getOperation(int itemIdx) {
        long structureIdAndOp = this.arr[4 * itemIdx + 3];
        return (int)(structureIdAndOp >> 32);
    }

    @Override
    public int getStructureId(int itemIdx) {
        long structureIdAndOp = this.arr[4 * itemIdx + 3];
        return (int)structureIdAndOp;
    }

    @Override
    public long getPageId(int itemIdx) {
        return this.arr[4 * itemIdx];
    }

    @Override
    public long getPageAddrHeader(int itemIdx) {
        return this.arr[4 * itemIdx + 1];
    }

    @Override
    public long getPageAddr(int itemIdx) {
        return this.arr[4 * itemIdx + 2];
    }

    @Override
    public PageMetaInfoStore copy() {
        return new HeapPageMetaInfoStore((long[])this.arr.clone());
    }

    @Override
    public void free() {
        if (this.memoryCalc != null) {
            this.memoryCalc.onHeapFree(this.arr.length * 8 + 40);
        }
        this.arr = null;
    }

    private long meta(int structureId, int op) {
        long major = (long)op << 32;
        long minor = (long)structureId & 0xFFFFFFFFL;
        return major | minor;
    }
}

