/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;

public class CacheJoinNodeDiscoveryData
implements Serializable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private final Map<String, CacheInfo> caches;
    @GridToStringInclude
    private final Map<String, CacheInfo> templates;
    @GridToStringInclude
    private final IgniteUuid cacheDeploymentId;
    private final boolean startCaches;

    public CacheJoinNodeDiscoveryData(IgniteUuid cacheDeploymentId, Map<String, CacheInfo> caches, Map<String, CacheInfo> templates, boolean startCaches) {
        this.cacheDeploymentId = cacheDeploymentId;
        this.caches = caches;
        this.templates = templates;
        this.startCaches = startCaches;
    }

    boolean startCaches() {
        return this.startCaches;
    }

    public IgniteUuid cacheDeploymentId() {
        return this.cacheDeploymentId;
    }

    public Map<String, CacheInfo> templates() {
        return this.templates;
    }

    public Map<String, CacheInfo> caches() {
        return this.caches;
    }

    public String toString() {
        return S.toString(CacheJoinNodeDiscoveryData.class, this);
    }

    public static class CacheInfo
    implements Serializable {
        private static final long serialVersionUID = 0L;
        @GridToStringInclude
        private StoredCacheData cacheData;
        @GridToStringInclude
        private CacheType cacheType;
        @GridToStringInclude
        private boolean sql;
        private long flags;
        private boolean staticallyConfigured;

        public CacheInfo(StoredCacheData cacheData, CacheType cacheType, boolean sql, long flags, boolean staticallyConfigured) {
            this.cacheData = cacheData;
            this.cacheType = cacheType;
            this.sql = sql;
            this.flags = flags;
            this.staticallyConfigured = staticallyConfigured;
        }

        public StoredCacheData cacheData() {
            return this.cacheData;
        }

        public CacheType cacheType() {
            return this.cacheType;
        }

        public boolean sql() {
            return this.sql;
        }

        public boolean isStaticallyConfigured() {
            return this.staticallyConfigured;
        }

        public long getFlags() {
            return this.flags;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField gf = ois.readFields();
            this.cacheData = (StoredCacheData)gf.get("cacheData", null);
            this.cacheType = (CacheType)((Object)gf.get("cacheType", null));
            this.sql = gf.get("sql", false);
            this.flags = gf.get("flags", 0L);
            this.staticallyConfigured = gf.get("staticallyConfigured", true);
        }

        public String toString() {
            return S.toString(CacheInfo.class, this);
        }
    }
}

