/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdatePartitionDataRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIOV2;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MetaPageUpdatePartitionDataRecordV2
extends MetaPageUpdatePartitionDataRecord {
    private long link;

    public MetaPageUpdatePartitionDataRecordV2(int grpId, long pageId, long updateCntr, long globalRmvId, int partSize, long cntrsPageId, byte state, int allocatedIdxCandidate, long link) {
        super(grpId, pageId, updateCntr, globalRmvId, partSize, cntrsPageId, state, allocatedIdxCandidate);
        this.link = link;
    }

    public MetaPageUpdatePartitionDataRecordV2(DataInput in) throws IOException {
        super(in);
        this.link = in.readLong();
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        super.applyDelta(pageMem, pageAddr);
        PagePartitionMetaIOV2 io = (PagePartitionMetaIOV2)PagePartitionMetaIO.VERSIONS.forPage(pageAddr);
        io.setGapsLink(pageAddr, this.link);
    }

    public long link() {
        return this.link;
    }

    @Override
    public void toBytes(ByteBuffer buf) {
        super.toBytes(buf);
        buf.putLong(this.link());
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.PARTITION_META_PAGE_UPDATE_COUNTERS_V2;
    }

    @Override
    public String toString() {
        return S.toString(MetaPageUpdatePartitionDataRecordV2.class, this, "partId", (Object)PageIdUtils.partId(this.pageId()), "super", (Object)super.toString());
    }
}

