/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.WalRecordCacheGroupAware;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;

public class PageSnapshot
extends WALRecord
implements WalRecordCacheGroupAware {
    @GridToStringExclude
    private byte[] pageDataBytes;
    private FullPageId fullPageId;
    private int realPageSize;

    public PageSnapshot(FullPageId fullId, byte[] arr, int realPageSize) {
        this.fullPageId = fullId;
        this.pageDataBytes = arr;
        this.realPageSize = realPageSize;
    }

    public PageSnapshot(FullPageId fullPageId, long ptr, int pageSize, int realPageSize) {
        this.fullPageId = fullPageId;
        this.realPageSize = realPageSize;
        this.pageDataBytes = this.toBytes(GridUnsafe.wrapPointer(ptr, pageSize));
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.PAGE_RECORD;
    }

    private byte[] toBytes(ByteBuffer pageData) {
        if (!pageData.isDirect()) {
            return Arrays.copyOf(pageData.array(), pageData.limit());
        }
        byte[] arr = new byte[pageData.limit()];
        GridUnsafe.copyMemory(null, GridUnsafe.bufferAddress(pageData), arr, GridUnsafe.BYTE_ARR_OFF, pageData.limit());
        return arr;
    }

    public byte[] pageData() {
        return this.pageDataBytes;
    }

    public int pageDataSize() {
        return this.pageDataBytes.length;
    }

    public ByteBuffer pageDataBuffer() {
        ByteBuffer buf = ByteBuffer.wrap(this.pageDataBytes).order(ByteOrder.nativeOrder());
        buf.rewind();
        return buf;
    }

    public FullPageId fullPageId() {
        return this.fullPageId;
    }

    @Override
    public int groupId() {
        return this.fullPageId.groupId();
    }

    public int realPageSize() {
        return this.realPageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ByteBuffer buf = ByteBuffer.allocateDirect(this.pageDataSize());
        buf.order(ByteOrder.nativeOrder());
        buf.put(this.pageDataBytes);
        long addr = GridUnsafe.bufferAddress(buf);
        try {
            String string = "PageSnapshot [fullPageId = " + this.fullPageId() + ", page = [\n" + PageIO.printPage(addr, this.realPageSize) + "],\nsuper = [" + super.toString() + "]]";
            return string;
        }
        finally {
            GridUnsafe.cleanDirectBuffer(buf);
        }
    }
}

