/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.systemview.walker;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.processors.query.stat.view.StatisticsColumnLocalDataView;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

public class StatisticsColumnLocalDataViewWalker
implements SystemViewRowAttributeWalker<StatisticsColumnLocalDataView> {
    public static final String SCHEMA_FILTER = "schema";
    public static final String TYPE_FILTER = "type";
    public static final String NAME_FILTER = "name";
    public static final String COLUMN_FILTER = "column";
    private static final List<String> FILTRABLE_ATTRS = Collections.unmodifiableList(F.asList(new String[]{"schema", "type", "name", "column"}));

    @Override
    public List<String> filtrableAttributes() {
        return FILTRABLE_ATTRS;
    }

    @Override
    public void visitAll(SystemViewRowAttributeWalker.AttributeVisitor v) {
        v.accept(0, SCHEMA_FILTER, String.class);
        v.accept(1, TYPE_FILTER, String.class);
        v.accept(2, NAME_FILTER, String.class);
        v.accept(3, COLUMN_FILTER, String.class);
        v.accept(4, "rowsCount", Long.TYPE);
        v.accept(5, "distinct", Long.TYPE);
        v.accept(6, "nulls", Long.TYPE);
        v.accept(7, "total", Long.TYPE);
        v.accept(8, "size", Integer.TYPE);
        v.accept(9, "version", Long.TYPE);
        v.accept(10, "lastUpdateTime", Timestamp.class);
    }

    @Override
    public void visitAll(StatisticsColumnLocalDataView row, SystemViewRowAttributeWalker.AttributeWithValueVisitor v) {
        v.accept(0, SCHEMA_FILTER, String.class, row.schema());
        v.accept(1, TYPE_FILTER, String.class, row.type());
        v.accept(2, NAME_FILTER, String.class, row.name());
        v.accept(3, COLUMN_FILTER, String.class, row.column());
        v.acceptLong(4, "rowsCount", row.rowsCount());
        v.acceptLong(5, "distinct", row.distinct());
        v.acceptLong(6, "nulls", row.nulls());
        v.acceptLong(7, "total", row.total());
        v.acceptInt(8, "size", row.size());
        v.acceptLong(9, "version", row.version());
        v.accept(10, "lastUpdateTime", Timestamp.class, row.lastUpdateTime());
    }

    @Override
    public int count() {
        return 11;
    }
}

