/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.snapshot;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.util.typedef.internal.U;

public class SnapshotCheckCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument(description="Snapshot name. In case incremental snapshot (--incremental) full snapshot name must be provided")
    private String snapshotName;
    @Argument(example="path", optional=true, description="Path to the directory where the snapshot files are located. If not specified, the default configured snapshot directory will be used")
    private String src;
    @Argument(example="incrementIndex", optional=true, description="Incremental snapshot index. The command will check incremental snapshots sequentially from 1 to the specified index")
    private int increment;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.snapshotName);
        U.writeString(out, this.src);
        out.writeInt(this.increment);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.snapshotName = U.readString(in);
        this.src = U.readString(in);
        this.increment = in.readInt();
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public void snapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public String src() {
        return this.src;
    }

    public void src(String src) {
        this.src = src;
    }

    public int increment() {
        return this.increment;
    }

    public void increment(int increment) {
        this.increment = increment;
    }
}

