/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.maintenance;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFoldersResolver;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.maintenance.MaintenanceTask;

public class MaintenanceFileStore {
    public static final String MAINTENANCE_FILE_NAME = "maintenance_tasks.mntc";
    private static final String TASKS_SEPARATOR = System.lineSeparator();
    private static final String TASK_PARTS_SEPARATOR = "\t";
    private static final int MAX_MNTC_TASK_PARTS_COUNT = 3;
    private final boolean disabled;
    private final PdsFoldersResolver pdsFoldersResolver;
    private volatile File mntcTasksFile;
    private volatile FileIO mntcTasksFileIO;
    private final FileIOFactory ioFactory;
    private final Map<String, MaintenanceTask> tasksInSync = new ConcurrentHashMap<String, MaintenanceTask>();
    private final IgniteLogger log;

    public MaintenanceFileStore(boolean disabled, PdsFoldersResolver pdsFoldersResolver, FileIOFactory ioFactory, IgniteLogger log) {
        this.disabled = disabled;
        this.pdsFoldersResolver = pdsFoldersResolver;
        this.ioFactory = ioFactory;
        this.log = log;
    }

    public void init() throws IgniteCheckedException, IOException {
        if (this.disabled) {
            return;
        }
        File storeDir = this.pdsFoldersResolver.resolveFolders().persistentStoreNodePath();
        U.ensureDirectory(storeDir, "store directory for node persistent data", this.log);
        this.mntcTasksFile = new File(storeDir, MAINTENANCE_FILE_NAME);
        if (!this.mntcTasksFile.exists()) {
            this.mntcTasksFile.createNewFile();
        }
        this.mntcTasksFileIO = this.ioFactory.create(this.mntcTasksFile);
        this.readTasksFromFile();
    }

    public void clear() {
        if (this.mntcTasksFile != null) {
            this.mntcTasksFile.delete();
        }
    }

    public void stop() throws IOException {
        if (this.disabled) {
            return;
        }
        if (this.mntcTasksFileIO != null) {
            this.mntcTasksFileIO.close();
        }
    }

    private void readTasksFromFile() throws IOException {
        String[] allTasks;
        int len = (int)this.mntcTasksFileIO.size();
        if (len == 0) {
            return;
        }
        byte[] allBytes = new byte[len];
        this.mntcTasksFileIO.read(allBytes, 0, len);
        for (String taskStr : allTasks = new String(allBytes).split(TASKS_SEPARATOR)) {
            String[] subStrs = taskStr.split(TASK_PARTS_SEPARATOR);
            int partsNum = subStrs.length;
            if (partsNum < 2) {
                this.log.info("Corrupted maintenance task found and will be skipped, mandatory parts are missing: " + taskStr);
                continue;
            }
            if (partsNum > 3) {
                this.log.info("Corrupted maintenance task found and will be skipped, too many parts in task: " + taskStr);
                continue;
            }
            String name = subStrs[0];
            MaintenanceTask task = new MaintenanceTask(name, subStrs[1], partsNum == 3 ? subStrs[2] : null);
            this.tasksInSync.put(name, task);
        }
    }

    private void writeTasksToFile() throws IOException {
        this.mntcTasksFileIO.clear();
        String allTasks = this.tasksInSync.values().stream().map(task -> task.name() + TASK_PARTS_SEPARATOR + task.description() + TASK_PARTS_SEPARATOR + (task.parameters() != null ? task.parameters() : "")).collect(Collectors.joining(System.lineSeparator()));
        byte[] allTasksBytes = allTasks.getBytes();
        int left = allTasksBytes.length;
        int len = allTasksBytes.length;
        while ((left -= this.mntcTasksFileIO.writeFully(allTasksBytes, len - left, left)) > 0) {
        }
        this.mntcTasksFileIO.force();
    }

    public Map<String, MaintenanceTask> getAllTasks() {
        if (this.disabled) {
            return null;
        }
        return Collections.unmodifiableMap(this.tasksInSync);
    }

    public void writeMaintenanceTask(MaintenanceTask task) throws IOException {
        if (this.disabled) {
            return;
        }
        this.tasksInSync.put(task.name(), task);
        this.writeTasksToFile();
    }

    public void deleteMaintenanceTask(String taskName) throws IOException {
        if (this.disabled) {
            return;
        }
        this.tasksInSync.remove(taskName);
        this.writeTasksToFile();
    }
}

