/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NumericInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.LongIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NumericIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class LongInlineIndexKeyType
extends NumericInlineIndexKeyType<LongIndexKey> {
    public LongInlineIndexKeyType() {
        super(IndexKeyType.LONG, (short)8);
    }

    @Override
    protected int put0(long pageAddr, int off, LongIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type().code());
        PageUtils.putLong(pageAddr, off + 1, (Long)key.key());
        return this.keySize + 1;
    }

    @Override
    protected LongIndexKey get0(long pageAddr, int off) {
        long key = PageUtils.getLong(pageAddr, off + 1);
        return new LongIndexKey(key);
    }

    @Override
    public int compare0(long pageAddr, int off, IndexKey key) {
        long val = PageUtils.getLong(pageAddr, off + 1);
        return -Integer.signum(((NumericIndexKey)key).compareTo(val));
    }
}

