/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryPositionReadable;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;

class RawBinaryObjectExtractor
implements BinaryPositionReadable {
    private final BinaryInputStream in;

    RawBinaryObjectExtractor(BinaryInputStream in) {
        this.in = in;
    }

    byte[] extractObject() {
        int startPos = this.in.position();
        this.skipObject();
        int endPos = this.in.position();
        this.in.position(startPos);
        return this.in.readByteArray(endPos - startPos);
    }

    void copyObject(BinaryOutputStream out) {
        int startPos = this.in.position();
        this.skipObject();
        out.writeByteArray(this.in.array(), startPos, this.in.position() - startPos);
    }

    void copyTypeId(BinaryOutputStream out) {
        int startPos = this.in.position();
        this.skipTypeId();
        out.writeByteArray(this.in.array(), startPos, this.in.position() - startPos);
    }

    void copyBytes(int cnt, BinaryOutputStream out) {
        assert (cnt >= 0);
        if (cnt == 0) {
            return;
        }
        out.writeByteArray(this.in.array(), this.in.position(), cnt);
        this.skipBytes(cnt);
    }

    int readInt() {
        return this.in.readInt();
    }

    void skipObject() {
        int objStartPos = this.in.position();
        byte type = this.in.readByte();
        switch (type) {
            case 101: {
                break;
            }
            case 103: {
                this.skipBytes(BinaryUtils.length(this.in, objStartPos) - 1);
                break;
            }
            case 27: {
                this.skipBytes(this.in.readInt());
                this.skipBytes(4);
                break;
            }
            case 1: 
            case 8: {
                this.skipBytes(1);
                break;
            }
            case 7: {
                this.skipBytes(2);
                break;
            }
            case 2: {
                this.skipBytes(2);
                break;
            }
            case 5: {
                this.skipBytes(4);
                break;
            }
            case 3: 
            case 102: {
                this.skipBytes(4);
                break;
            }
            case 28: 
            case 38: {
                this.skipTypeId();
                this.skipBytes(4);
                break;
            }
            case 4: 
            case 11: 
            case 36: {
                this.skipBytes(8);
                break;
            }
            case 6: {
                this.skipBytes(8);
                break;
            }
            case -2: 
            case 9: {
                this.skipBytes(this.in.readInt());
                break;
            }
            case 30: {
                this.skipBytes(4);
                this.skipBytes(this.in.readInt());
                break;
            }
            case 10: {
                this.skipBytes(16);
                break;
            }
            case 33: {
                this.skipBytes(12);
                break;
            }
            case 12: 
            case 19: {
                this.skipBytes(this.in.readInt() * 1);
                break;
            }
            case 18: {
                this.skipBytes(this.in.readInt() * 2);
                break;
            }
            case 13: {
                this.skipBytes(this.in.readInt() * 2);
                break;
            }
            case 14: {
                this.skipBytes(this.in.readInt() * 4);
                break;
            }
            case 16: {
                this.skipBytes(this.in.readInt() * 4);
                break;
            }
            case 15: {
                this.skipBytes(this.in.readInt() * 8);
                break;
            }
            case 17: {
                this.skipBytes(this.in.readInt() * 8);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 34: 
            case 37: {
                this.skipCortege();
                break;
            }
            case 23: 
            case 29: {
                this.skipTypeId();
                this.skipCortege();
                break;
            }
            case 24: {
                int size = this.in.readInt();
                this.skipBytes(1);
                this.skipCortege(size);
                break;
            }
            case 25: {
                int size = this.in.readInt() * 2;
                this.skipBytes(1);
                this.skipCortege(size);
                break;
            }
            case 32: {
                this.skipTypeId();
                break;
            }
            case 35: {
                int size = this.in.readInt();
                for (int i = 0; i < size; ++i) {
                    this.skipTypeId();
                }
                this.skipObject();
                break;
            }
            default: {
                throw new BinaryObjectException("Unsupported binary type [type=" + type + "]");
            }
        }
    }

    @Override
    public byte readBytePositioned(int pos) {
        return this.in.readBytePositioned(pos);
    }

    @Override
    public short readShortPositioned(int pos) {
        return this.in.readShortPositioned(pos);
    }

    @Override
    public int readIntPositioned(int pos) {
        return this.in.readIntPositioned(pos);
    }

    int position() {
        return this.in.position();
    }

    void position(int position) {
        this.in.position(position);
    }

    byte peekByte() {
        return this.in.readBytePositioned(this.in.position());
    }

    int peekInt() {
        return this.in.readIntPositioned(this.in.position());
    }

    void skipBytes(int count) {
        int curPos = this.in.position();
        this.in.position(curPos + count);
    }

    void skipTypeId() {
        int typeId = this.in.readInt();
        if (typeId == 0) {
            this.skipObject();
        }
    }

    byte[] array() {
        return this.in.array();
    }

    private void skipCortege() {
        this.skipCortege(this.in.readInt());
    }

    private void skipCortege(int size) {
        for (int i = 0; i < size; ++i) {
            this.skipObject();
        }
    }
}

