/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.hint.HintUtils;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteColocatedSortAggregate;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteMapSortAggregate;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteReduceSortAggregate;
import org.apache.ignite.internal.processors.query.calcite.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.util.typedef.F;

public class SortAggregateConverterRule {
    public static final RelOptRule COLOCATED = new ColocatedSortAggregateConverterRule();
    public static final RelOptRule MAP_REDUCE = new MapReduceSortAggregateConverterRule();

    private SortAggregateConverterRule() {
    }

    private static class MapReduceSortAggregateConverterRule
    extends AbstractIgniteConverterRule<LogicalAggregate> {
        MapReduceSortAggregateConverterRule() {
            super(LogicalAggregate.class, "MapReduceSortAggregateConverterRule");
        }

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalAggregate agg) {
            if (F.isEmpty((Iterable)agg.getGroupSet()) || agg.getGroupSets().size() > 1) {
                return null;
            }
            if (HintUtils.isExpandDistinctAggregate(agg)) {
                return null;
            }
            RelOptCluster cluster = agg.getCluster();
            RelNode input = agg.getInput();
            RelCollation collation = TraitUtils.createCollation(agg.getGroupSet().asList());
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)collation);
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)collation);
            IgniteMapSortAggregate map = new IgniteMapSortAggregate(cluster, outTrait.replace((RelTrait)IgniteDistributions.random()), MapReduceSortAggregateConverterRule.convert((RelNode)input, (RelTraitSet)inTrait), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList(), collation);
            return new IgniteReduceSortAggregate(cluster, outTrait.replace((RelTrait)IgniteDistributions.single()), MapReduceSortAggregateConverterRule.convert((RelNode)map, (RelTraitSet)inTrait.replace((RelTrait)IgniteDistributions.single())), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList(), agg.getRowType(), collation);
        }
    }

    private static class ColocatedSortAggregateConverterRule
    extends AbstractIgniteConverterRule<LogicalAggregate> {
        ColocatedSortAggregateConverterRule() {
            super(LogicalAggregate.class, "ColocatedSortAggregateConverterRule");
        }

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalAggregate agg) {
            if (F.isEmpty((Iterable)agg.getGroupSet()) || agg.getGroupSets().size() > 1) {
                return null;
            }
            if (HintUtils.isExpandDistinctAggregate(agg)) {
                return null;
            }
            RelOptCluster cluster = agg.getCluster();
            RelNode input = agg.getInput();
            RelCollation collation = TraitUtils.createCollation(agg.getGroupSet().asList());
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)collation).replace((RelTrait)IgniteDistributions.single());
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)collation).replace((RelTrait)IgniteDistributions.single());
            return new IgniteColocatedSortAggregate(cluster, outTrait, ColocatedSortAggregateConverterRule.convert((RelNode)input, (RelTraitSet)inTrait), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList(), collation);
        }
    }
}

