/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel.agg;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteAggregate;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitsAwareIgniteRel;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

public abstract class IgniteColocatedAggregateBase
extends IgniteAggregate
implements TraitsAwareIgniteRel {
    protected IgniteColocatedAggregateBase(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traitSet, input, groupSet, groupSets, aggCalls);
    }

    protected IgniteColocatedAggregateBase(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        IgniteDistribution distr = TraitUtils.distribution(nodeTraits);
        if (distr == IgniteDistributions.single() || distr.function().correlated()) {
            return Pair.of((Object)nodeTraits, Commons.transform(inTraits, t -> t.replace((RelTrait)distr)));
        }
        return null;
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits, (Object)ImmutableList.of((Object)inputTraits.get(0))));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        IgniteDistribution inDistribution = TraitUtils.distribution(inputTraits.get(0));
        if (inDistribution.satisfies((RelTrait)IgniteDistributions.single())) {
            return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.single()), inputTraits));
        }
        if (inDistribution.getType() == RelDistribution.Type.HASH_DISTRIBUTED) {
            for (Integer key : inDistribution.getKeys()) {
                if (this.groupSet.get(key.intValue())) continue;
                return ImmutableList.of();
            }
            IgniteDistribution outDistribution = inDistribution.apply(Commons.mapping(this.groupSet, this.rowType.getFieldCount()));
            return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)outDistribution), inputTraits));
        }
        return ImmutableList.of();
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)TraitUtils.correlation(inTraits.get(0))), inTraits));
    }
}

