/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite.internal.util.typedef.X;

public class CacheKey {
    private final String schemaName;
    private final String query;
    private final Object contextKey;
    private final Class<?>[] paramTypes;

    public CacheKey(String schemaName, String query, Object contextKey, Object[] params) {
        this.schemaName = schemaName;
        this.query = query;
        this.contextKey = contextKey;
        this.paramTypes = params.length == 0 ? null : (Class[])Arrays.stream(params).map(p -> p != null ? p.getClass() : Void.class).toArray(Class[]::new);
    }

    public CacheKey(String schemaName, String query) {
        this(schemaName, query, null, X.EMPTY_OBJECT_ARRAY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)o;
        if (!this.schemaName.equals(cacheKey.schemaName)) {
            return false;
        }
        if (!this.query.equals(cacheKey.query)) {
            return false;
        }
        if (!Objects.equals(this.contextKey, cacheKey.contextKey)) {
            return false;
        }
        return Arrays.deepEquals(this.paramTypes, cacheKey.paramTypes);
    }

    public int hashCode() {
        int result = this.schemaName.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + (this.contextKey != null ? this.contextKey.hashCode() : 0);
        result = 31 * result + Arrays.deepHashCode(this.paramTypes);
        return result;
    }
}

